---
title: Text manipulation with the sed command line tool on Linux
summary: Learn to do basic text editing from the command line using sed
---

sed is a powerfull stream editor for filtering and transforming text. I will show you how to utilize it's most important features to edit files without opening them in a text editor. This tool is used by devops engineers, system administrators and developers to make quick changes to configuration files, logs, and other text data.

## Getting Started with Basic substitution

The most straightforward way to use sed is to substitute text. Simply type:

```bash
sed 's/old/new/' filename
```

Let's say you have a config file with wrong database credentials:

```bash
# database.conf
host=db.old-domain.com
user=admin
password=secretpass
```

To update the hostname:

```bash
sed 's/db.old-domain.com/db.new-domain.com/' database.conf
```

We can also use differnt delimiters when forward slashes appear in the pattern:

```bash
sed 's#/usr/local/bin#/opt/bin#' path.txt
```

## MAKING GLOBAL CHANGES

By default sed only changes the first occurence on each line. To change all occurences, add the 'g' flag:

```bash
sed 's/cat/dog/g' pets.txt
```

For example, with this log file:

```
cat food ordered
cat toys received
cat medicine prescribed
```

The command will change every instance of "cat" to "dog".

## Working with Files In-Place

Obviously, you'll want to save your changes sometimes. Use `-i`:

```bash
sed -i 's/error/warning/g' logfile.txt
```

You can also make backup copies:

```bash
sed -i.bak 's/DEBUG/INFO/g' app.log
```

This creates app.log.bak before making changes.

## Advanced Pattern Matching

We can match patterns using regular expressions:

```bash
# Remove all lines starting with comments
sed '/^#/d' config.txt

# Add quotes around numbers
sed 's/\([0-9]\+\)/"\1"/' data.txt
```

## Conclusion

You learned the basics of sed text manipulation. Practice these commands to become more familiar with them. Remember to always backup important files before editing them with sed. [Click here](https://google.com).
