---
title: Working with dates in the terminal
summary: Format and manipulate dates using the date command
---

The date command in Unix-like operating systems enables you to display and manipulate dates and times. It's particularly useful in scripts and for system administration tasks.

## Basic Usage

Display current date:

```bash
date
```

Output might look like:
```
Fri Feb 17 15:30:45 PST 2024
```

## Custom Formatting

Format the output:

```bash
# ISO format
date "+%Y-%m-%d"

# Timestamp for filenames
date "+%Y%m%d_%H%M%S"

# RFC 3339 format
date --rfc-3339=seconds
```

Practical examples:

```bash
# Create backup with timestamp
cp logfile.txt logfile_$(date +%Y%m%d).bak

# Calculate future date
date -d "+7 days" "+%Y-%m-%d"

# Convert timestamp to human-readable
date -d @1645062000
```

## Working with Different Timezones

Display time in different zones:

```bash
# Show time in UTC
date -u

# Use specific timezone
TZ='America/New_York' date

# List available timezones
ls /usr/share/zoneinfo
```

## Setting System Time

I can change system time (requires root):

```bash
sudo date --set="2024-02-17 15:30:00"
```

Warning: Setting incorrect system time can cause problems with:
- SSL certificates
- Scheduled tasks
- Log timestamps
- Database transactions

## Conclusion

The date command is useful for scripting and system administration tasks. Remember to be carefull when modifying system time on production servers.