func evalSelectExpression(se *ast.TSelectExpression, scope *TScope) IObject {
	sexp := Eval(se.Expression, scope)
	if obj, ok := ObjectState(sexp, SilentNil); !ok {
		return obj;
	}
	
	var def				*ast.TDefaultBlock
	var execBlock bool
	
	// each case
	for _, cases := range se.Cases {
		execBlock = false
		
		if obj, ok := cases.(*ast.TDefaultBlock); ok {
			// save default block
			def = obj
			continue
		}
		
		// each expression of each case
		for _, cexps := range cases.(*ast.TCaseBlock).Expressions {
			
			switch cexps.(type) {
			case *ast.TFromToExpression:
				cexp := cexps.(*ast.TFromToExpression).Expression
				if left, right, _, errObj, ok := evalLeftRight(cexp, NewScope(scope)); ok {
					if exec, errObj, ok := isFromTo(sexp, left, right); ok {
						execBlock = exec
					} else {
						return errObj
					}
				} else {
					return errObj
				}
			default:
				cexp := Eval(cexps, NewScope(scope))
				if obj, ok := ObjectState(cexp, SilentNil); !ok {
					return obj;
				}
				if cexp.Type() == BOOLEAN_OBJ {
					execBlock = cexp.(*TBoolean).Value
				} else {
					if exec, errObj, ok := isEqual(cexp, sexp); ok {
						execBlock = exec
					} else {
						return errObj
					}
				}
			}
			
			if execBlock {
				sexp = Eval(cases.(*ast.TCaseBlock).Block, NewScope(scope))
				return nil
			}
		}
	}
	
	// execute default if present
	if def != nil {
		sexp = Eval(def.Block, NewScope(scope))
	}
	
	return nil
}