	// APPEND: ARRAY, MAP
	BUILTIN_APPEND: &TBuiltin { Statement: false, 
		Fn: func(line string, args ...IObject) IObject {
			arc := len(args)
			if arc != 2 {
				return ERR_INVALID_ARG_COUNT(arc)
			}
			
			if args[0].Type() != ARRAY_OBJ {
				return ERR_ARG_NOT_ARRAY(args[0])
			}
			
			arr := args[0].(*TArray)
			arrl := len(arr.Elements)
			
			newElements := make([]IObject, arrl + 1, arrl + 1)
			
			copy(newElements, arr.Elements)
			newElements[arrl] = args[1]
			
			return &TArray { Elements: newElements }
		},
	},
	
