// object/number.go

package object

import (
	"strconv"
	)

type CompareType int8

var CmpNOMATCH, CmpEQUAL, CmpGREATER, CmpLESS, CmpWITHIN, CmpINVALID CompareType = 0, 1, 2, 3, 4, -1


func BooleanValue(val bool) IObject {
	return &TBoolean { Value: val }
}

func ByteValue(val int8) IObject {
	return &TByte { Value: val }
}

func DoubleValue(val float64) IObject {
	return &TDouble { Value: val }
}

func IntegerValue(val int64) IObject {
	return &TInteger { Value: val }
}

func LongValue(val int32) IObject {
	return &TLong { Value: val }
}

func ShortValue(val int16) IObject {
	return &TShort { Value: val }
}

func SingleValue(val float32) IObject {
	return &TSingle { Value: val }
}

func StringValue(val string) IObject {
	return &TString { Value: val }
}

func UByteValue(val uint8) IObject {
	return &TUByte { Value: val }
}

func UIntegerValue(val uint64) IObject {
	return &TUInteger { Value: val }
}

func ULongValue(val uint32) IObject {
	return &TULong { Value: val }
}

func UShortValue(val uint16) IObject {
	return &TUShort { Value: val }
}


func CompareNumber(number, comparant IObject) CompareType {
	switch comparant.(type) {
	
	case *TInteger:
		cv,_ := IntegerObject(number, IMPLICIT)
		if cv.(*TInteger).Value < comparant.(*TInteger).Value {
			return CmpLESS
			
		} else if cv.(*TInteger).Value > comparant.(*TInteger).Value {
			return CmpGREATER
			
		} else {
			return CmpEQUAL
		}
	
	case *TUInteger:
		cv,_ := UIntegerObject(number, IMPLICIT)
		if cv.(*TUInteger).Value < comparant.(*TUInteger).Value {
			return CmpLESS
			
		} else if cv.(*TUInteger).Value > comparant.(*TUInteger).Value {
			return CmpGREATER
			
		} else {
			return CmpEQUAL
		}
			
	case *TDouble:
		cv,_ := DoubleObject(number, IMPLICIT)
		if cv.(*TDouble).Value < comparant.(*TDouble).Value {
			return CmpLESS
			
		} else if cv.(*TDouble).Value > comparant.(*TDouble).Value {
			return CmpGREATER
			
		} else {
			return CmpEQUAL
		}
		
	case *TSingle:
		cv,_ := SingleObject(number, IMPLICIT)
		if cv.(*TSingle).Value < comparant.(*TSingle).Value {
			return CmpLESS
			
		} else if cv.(*TSingle).Value > comparant.(*TSingle).Value {
			return CmpGREATER
			
		} else {
			return CmpEQUAL
		}
	
	case *TLong:
		cv,_ := LongObject(number, IMPLICIT)
		if cv.(*TLong).Value < comparant.(*TLong).Value {
			return CmpLESS
			
		} else if cv.(*TLong).Value > comparant.(*TLong).Value {
			return CmpGREATER
			
		} else {
			return CmpEQUAL
		}
	
	case *TShort:
		cv,_ := ShortObject(number, IMPLICIT)
		if cv.(*TShort).Value < comparant.(*TShort).Value {
			return CmpLESS
			
		} else if cv.(*TShort).Value > comparant.(*TShort).Value {
			return CmpGREATER
			
		} else {
			return CmpEQUAL
		}
	
	case *TByte:
		cv,_ := ByteObject(number, IMPLICIT)
		if cv.(*TByte).Value < comparant.(*TByte).Value {
			return CmpLESS
			
		} else if cv.(*TByte).Value > comparant.(*TByte).Value {
			return CmpGREATER
			
		} else {
			return CmpEQUAL
		}
	
	case *TULong:
		cv,_ := ULongObject(number, IMPLICIT)
		if cv.(*TULong).Value < comparant.(*TULong).Value {
			return CmpLESS
			
		} else if cv.(*TULong).Value > comparant.(*TULong).Value {
			return CmpGREATER
			
		} else {
			return CmpEQUAL
		}
	
	case *TUShort:
		cv,_ := UShortObject(number, IMPLICIT)
		if cv.(*TUShort).Value < comparant.(*TUShort).Value {
			return CmpLESS
			
		} else if cv.(*TUShort).Value > comparant.(*TUShort).Value {
			return CmpGREATER
			
		} else {
			return CmpEQUAL
		}
	
	case *TUByte:
		cv,_ := UByteObject(number, IMPLICIT)
		if cv.(*TUByte).Value < comparant.(*TUByte).Value {
			return CmpLESS
			
		} else if cv.(*TUByte).Value > comparant.(*TUByte).Value {
			return CmpGREATER
			
		} else {
			return CmpEQUAL
		}
		
	}
	return CmpINVALID
}


func CompareNumberWithin(number, low, high IObject) CompareType {
	if low.Type() != high.Type() {
		return CmpINVALID
	}
	
	switch low.(type) {
			
	case *TDouble:
		cv,_ := DoubleObject(number, IMPLICIT)
		if cv.(*TDouble).Value >= low.(*TDouble).Value && cv.(*TDouble).Value <= high.(*TDouble).Value {
			return CmpWITHIN
		}
		
	case *TSingle:
		cv,_ := SingleObject(number, IMPLICIT)
		if cv.(*TSingle).Value >= low.(*TSingle).Value && cv.(*TSingle).Value <= high.(*TSingle).Value {
			return CmpWITHIN
		}
	
	case *TInteger:
		cv,_ := IntegerObject(number, IMPLICIT)
		if cv.(*TInteger).Value >= low.(*TInteger).Value && cv.(*TInteger).Value <= high.(*TInteger).Value {
			return CmpWITHIN
		}
		
	case *TLong:
		cv,_ := LongObject(number, IMPLICIT)
		if cv.(*TLong).Value >= low.(*TLong).Value && cv.(*TLong).Value <= high.(*TLong).Value {
			return CmpWITHIN
		}
	
	case *TShort:
		cv,_ := ShortObject(number, IMPLICIT)
		if cv.(*TShort).Value >= low.(*TShort).Value && cv.(*TShort).Value <= high.(*TShort).Value {
			return CmpWITHIN
		}
		
	case *TByte:
		cv,_ := ByteObject(number, IMPLICIT)
		if cv.(*TByte).Value >= low.(*TByte).Value && cv.(*TByte).Value <= high.(*TByte).Value {
			return CmpWITHIN
		}
	
	case *TUInteger:
		cv,_ := UIntegerObject(number, IMPLICIT)
		if cv.(*TUInteger).Value >= low.(*TUInteger).Value && cv.(*TUInteger).Value <= high.(*TUInteger).Value {
			return CmpWITHIN
		}
		
	case *TULong:
		cv,_ := ULongObject(number, IMPLICIT)
		if cv.(*TULong).Value >= low.(*TULong).Value && cv.(*TULong).Value <= high.(*TULong).Value {
			return CmpWITHIN
		}
	
	case *TUShort:
		cv,_ := UShortObject(number, IMPLICIT)
		if cv.(*TUShort).Value >= low.(*TUShort).Value && cv.(*TUShort).Value <= high.(*TUShort).Value {
			return CmpWITHIN
		}
		
	case *TUByte:
		cv,_ := UByteObject(number, IMPLICIT)
		if cv.(*TUByte).Value >= low.(*TUByte).Value && cv.(*TUByte).Value <= high.(*TUByte).Value {
			return CmpWITHIN
		}
	default:
		return CmpINVALID
	}
	
	return CmpNOMATCH
}


func SetNumber(number, value IObject) (IObject, bool) {
	var result IObject
	
	switch number.(type) {
	case *TBoolean:
		result,_ = BooleanObject(value, IMPLICIT)
	case *TByte:
		result,_ = ByteObject(value, IMPLICIT)
	case *TDouble:
		result,_ = DoubleObject(value, IMPLICIT)
	case *TInteger:
		result,_ = IntegerObject(value, IMPLICIT)
	case *TLong:
		result,_ = LongObject(value, IMPLICIT)
	case *TShort:
		result,_ = ShortObject(value, IMPLICIT)
	case *TSingle:
		result,_ = SingleObject(value, IMPLICIT)
	case *TUByte:
		result,_ = UByteObject(value, IMPLICIT)
	case *TUInteger:
		result,_ = UIntegerObject(value, IMPLICIT)
	case *TULong:
		result,_ = ULongObject(value, IMPLICIT)
	case *TUShort:
		result,_ = UShortObject(value, IMPLICIT)
	default:
		return number, false
	}
	
	return result, true
}

func AddNumber(number, value IObject) (IObject, bool) {
	
	switch number.(type) {
	case *TByte:
		num := number.(*TByte).Value
		obj,_ := ByteObject(value, IMPLICIT)
		val := obj.(*TByte).Value
		return ByteValue(num + val), true
	case *TDouble:
		num := number.(*TDouble).Value
		obj,_ := DoubleObject(value, EXPLICIT)
		val := obj.(*TDouble).Value
		return DoubleValue(num + val), true
	case *TInteger:
		num := number.(*TInteger).Value
		obj,_ := IntegerObject(value, EXPLICIT)
		val := obj.(*TInteger).Value
		return IntegerValue(num + val), true
	case *TLong:
		num := number.(*TLong).Value
		obj,_ := LongObject(value, EXPLICIT)
		val := obj.(*TLong).Value
		return LongValue(num + val), true
	case *TShort:
		num := number.(*TShort).Value
		obj,_ := ShortObject(value, EXPLICIT)
		val := obj.(*TShort).Value
		return ShortValue(num + val), true
	case *TSingle:
		num := number.(*TSingle).Value
		obj,_ := SingleObject(value, EXPLICIT)
		val := obj.(*TSingle).Value
		return SingleValue(num + val), true
	case *TUByte:
		num := number.(*TUByte).Value
		obj,_ := UByteObject(value, EXPLICIT)
		val := obj.(*TUByte).Value
		return UByteValue(num + val), true
	case *TUInteger:
		num := number.(*TUInteger).Value
		obj,_ := UIntegerObject(value, EXPLICIT)
		val := obj.(*TUInteger).Value
		return UIntegerValue(num + val), true
	case *TULong:
		num := number.(*TULong).Value
		obj,_ := ULongObject(value, EXPLICIT)
		val := obj.(*TULong).Value
		return ULongValue(num + val), true
	case *TUShort:
		num := number.(*TUShort).Value
		obj,_ := UShortObject(value, IMPLICIT)
		val := obj.(*TUShort).Value
		return UShortValue(num + val), true
	}
	
	return nil, false
}

/* until it is needed...
func SubtractNumber(number, value IObject) (IObject, bool) {
	
	switch number.(type) {
	case *TByte:
		num := number.(*TByte).Value
		obj,_ := ByteObject(value, IMPLICIT)
		val := obj.(*TByte).Value
		return ByteValue(num - val), true
	case *TDouble:
		num := number.(*TDouble).Value
		obj,_ := DoubleObject(value, EXPLICIT)
		val := obj.(*TDouble).Value
		return DoubleValue(num - val), true
	case *TInteger:
		num := number.(*TInteger).Value
		obj,_ := IntegerObject(value, EXPLICIT)
		val := obj.(*TInteger).Value
		return IntegerValue(num - val), true
	case *TLong:
		num := number.(*TLong).Value
		obj,_ := LongObject(value, EXPLICIT)
		val := obj.(*TLong).Value
		return LongValue(num - val), true
	case *TShort:
		num := number.(*TShort).Value
		obj,_ := ShortObject(value, EXPLICIT)
		val := obj.(*TShort).Value
		return ShortValue(num - val), true
	case *TSingle:
		num := number.(*TSingle).Value
		obj,_ := SingleObject(value, EXPLICIT)
		val := obj.(*TSingle).Value
		return SingleValue(num - val), true
	case *TUByte:
		num := number.(*TUByte).Value
		obj,_ := UByteObject(value, EXPLICIT)
		val := obj.(*TUByte).Value
		return UByteValue(num - val), true
	case *TUInteger:
		num := number.(*TUInteger).Value
		obj,_ := UIntegerObject(value, EXPLICIT)
		val := obj.(*TUInteger).Value
		return UIntegerValue(num - val), true
	case *TULong:
		num := number.(*TULong).Value
		obj,_ := ULongObject(value, EXPLICIT)
		val := obj.(*TULong).Value
		return ULongValue(num - val), true
	case *TUShort:
		num := number.(*TUShort).Value
		obj,_ := UShortObject(value, IMPLICIT)
		val := obj.(*TUShort).Value
		return UShortValue(num - val), true
	}
	
	return nil, false
}
*/

func BooleanObject(obj IObject, assign AssignType) (IObject, bool) {
	switch obj.Type() {
		
	case BOOLEAN_OBJ:
		return obj, true
		
	case BYTE_OBJ:
		val := obj.(*TByte).Value
		return BooleanValue(val != 0), true
	
	case DOUBLE_OBJ:
		val := obj.(*TDouble).Value
		return BooleanValue(val != 0), true
	
	case SINGLE_OBJ:
		val := obj.(*TSingle).Value
		return BooleanValue(val != 0), true
	
	case INTEGER_OBJ:
		val := obj.(*TInteger).Value
		return BooleanValue(val != 0), true
	
	case LONG_OBJ:
		val := obj.(*TLong).Value
		return BooleanValue(val != 0), true
	
	case SHORT_OBJ:
		val := obj.(*TShort).Value
		return BooleanValue(val != 0), true
	
	case STRING_OBJ:
		if assign == EXPLICIT {
			val := obj.(*TString).Value
			return BooleanValue(val != ""), true
		}
		
	case UBYTE_OBJ:
		val := obj.(*TUByte).Value
		return BooleanValue(val != 0), true
	
	case UINTEGER_OBJ:
		val := obj.(*TUInteger).Value
		return BooleanValue(val != 0), true
	
	case ULONG_OBJ:
		val := obj.(*TULong).Value
		return BooleanValue(val != 0), true
	
	case USHORT_OBJ:
		val := obj.(*TUShort).Value
		return BooleanValue(val != 0), true
	default:
		if dobj, ok := Deref(obj); ok {
			return BooleanObject(dobj, assign)
		}
	}
	
	return nil, false
}


func ByteObject(obj IObject, assign AssignType) (IObject, bool) {
	switch obj.Type() {
		
	case BOOLEAN_OBJ:		
		val := obj.(*TBoolean).Value
		if val == true {
			return ByteValue(-1), true
		} else {
			return ByteValue(0), true
		}
	case BYTE_OBJ:
		return obj, true
	
	case DOUBLE_OBJ:
		val := obj.(*TDouble).Value
		return ByteValue(int8(val)), true
	
	case SINGLE_OBJ:
		val := obj.(*TSingle).Value
		return ByteValue(int8(val)), true
	
	case INTEGER_OBJ:
		val := obj.(*TInteger).Value
		return ByteValue(int8(val)), true
	
	case LONG_OBJ:
		val := obj.(*TLong).Value
		return ByteValue(int8(val)), true
	
	case SHORT_OBJ:
		val := obj.(*TShort).Value
		return ByteValue(int8(val)), true
				
	case STRING_OBJ:
		if assign == EXPLICIT {
			if val, err := strconv.Atoi(obj.(*TString).Value); err != nil {
				return ByteValue(0), true
			} else {
				return ByteValue(int8(val)), true
			}
		}
		
	case UBYTE_OBJ:
		val := obj.(*TUByte).Value
		return ByteValue(int8(val)), true
	
	case UINTEGER_OBJ:
		val := obj.(*TUInteger).Value
		return ByteValue(int8(val)), true
	
	case ULONG_OBJ:
		val := obj.(*TULong).Value
		return ByteValue(int8(val)), true
	
	case USHORT_OBJ:
		val := obj.(*TUShort).Value
		return ByteValue(int8(val)), true
		
	default:
		if dobj, ok := Deref(obj); ok {
			return ByteObject(dobj, assign)
		}
	}
	
	return nil, false
}


func DoubleObject(obj IObject, assign AssignType) (IObject, bool) {
	switch obj.Type() {
		
	case BOOLEAN_OBJ:
		val := obj.(*TBoolean).Value
		if val == true {
			return DoubleValue(-1), true
		} else {
			return DoubleValue(0), true
		}
		
	case BYTE_OBJ:
		val := obj.(*TByte).Value
		return DoubleValue(float64(val)), true
	
	case DOUBLE_OBJ:
		return obj, true
	
	case SINGLE_OBJ:
		val := obj.(*TSingle).Value
		return DoubleValue(float64(val)), true
	
	case INTEGER_OBJ:
		val := obj.(*TInteger).Value
		return DoubleValue(float64(val)), true
	
	case LONG_OBJ:
		val := obj.(*TLong).Value
		return DoubleValue(float64(val)), true
	
	case SHORT_OBJ:
		val := obj.(*TShort).Value
		return DoubleValue(float64(val)), true
				
	case STRING_OBJ:
		if assign == EXPLICIT {
			if val, err := strconv.ParseFloat(obj.(*TString).Value, 64); err != nil {
				return DoubleValue(0), true
			} else {
				return DoubleValue(val), true
			}
		}
	case UBYTE_OBJ:
		val := obj.(*TUByte).Value
		return DoubleValue(float64(val)), true
	
	case UINTEGER_OBJ:
		val := obj.(*TUInteger).Value
		return DoubleValue(float64(val)), true
	
	case ULONG_OBJ:
		val := obj.(*TULong).Value
		return DoubleValue(float64(val)), true
	
	case USHORT_OBJ:
		val := obj.(*TUShort).Value
		return DoubleValue(float64(val)), true
		
	default:
		if dobj, ok := Deref(obj); ok {
			return DoubleObject(dobj, assign)
		}
	}
	
	return nil, false
}


func SingleObject(obj IObject, assign AssignType) (IObject, bool) {
	switch obj.Type() {
		
	case BOOLEAN_OBJ:
		val := obj.(*TBoolean).Value
		if val == true {
			return SingleValue(-1), true
		} else {
			return SingleValue(0), true
		}
		
	case BYTE_OBJ:
		val := obj.(*TByte).Value
		return SingleValue(float32(val)), true
	
	case DOUBLE_OBJ:
		val := obj.(*TDouble).Value
		return SingleValue(float32(val)), true
	
	case SINGLE_OBJ:
		return obj, true
	
	case INTEGER_OBJ:
		val := obj.(*TInteger).Value
		return SingleValue(float32(val)), true
	
	case LONG_OBJ:
		val := obj.(*TLong).Value
		return SingleValue(float32(val)), true
	
	case SHORT_OBJ:
		val := obj.(*TShort).Value
		return SingleValue(float32(val)), true
		
	case STRING_OBJ:
		if assign == EXPLICIT {
			if val, err := strconv.ParseFloat(obj.(*TString).Value, 32); err != nil {
				return SingleValue(0), true
			} else {
				return SingleValue(float32(val)), true
			}
		}
	case UBYTE_OBJ:
		val := obj.(*TUByte).Value
		return SingleValue(float32(val)), true
	
	case UINTEGER_OBJ:
		val := obj.(*TUInteger).Value
		return SingleValue(float32(val)), true
	
	case ULONG_OBJ:
		val := obj.(*TULong).Value
		return SingleValue(float32(val)), true
	
	case USHORT_OBJ:
		val := obj.(*TUShort).Value
		return SingleValue(float32(val)), true
	
	default:
		if dobj, ok := Deref(obj); ok {
			return SingleObject(dobj, assign)
		}
	}
	
	return nil, false
}



func IntegerObject(obj IObject, assign AssignType) (IObject, bool) {
	switch obj.Type() {
		
	case BOOLEAN_OBJ:
		val := obj.(*TBoolean).Value
		if val == true {
			return IntegerValue(-1), true
		} else {
			return IntegerValue(0), true
		}
		
	case BYTE_OBJ:
		val := obj.(*TByte).Value
		return IntegerValue(int64(val)), true
	
	case DOUBLE_OBJ:
		val := obj.(*TDouble).Value
		return IntegerValue(int64(val)), true
	
	case SINGLE_OBJ:
		val := obj.(*TSingle).Value
		return IntegerValue(int64(val)), true
	
	case INTEGER_OBJ:
		return obj, true
	
	case LONG_OBJ:
		val := obj.(*TLong).Value
		return IntegerValue(int64(val)), true
	
	case SHORT_OBJ:
		val := obj.(*TShort).Value
		return IntegerValue(int64(val)), true
				
	case STRING_OBJ:
		if assign == EXPLICIT {
			if val, err := strconv.Atoi(obj.(*TString).Value); err != nil {
				return IntegerValue(0), true
			} else {
				return IntegerValue(int64(val)), true
			}
		}
		
	case UBYTE_OBJ:
		val := obj.(*TUByte).Value
		return IntegerValue(int64(val)), true
	
	case UINTEGER_OBJ:
		val := obj.(*TUInteger).Value
		return IntegerValue(int64(val)), true
	
	case ULONG_OBJ:
		val := obj.(*TULong).Value
		return IntegerValue(int64(val)), true
	
	case USHORT_OBJ:
		val := obj.(*TUShort).Value
		return IntegerValue(int64(val)), true
	
	default:
		if dobj, ok := Deref(obj); ok {
			return IntegerObject(dobj, assign)
		}
	}
	
	return nil, false
}


func LongObject(obj IObject, assign AssignType) (IObject, bool) {
	switch obj.Type() {
		
	case BOOLEAN_OBJ:
		val := obj.(*TBoolean).Value
		if val == true {
			return LongValue(-1), true
		} else {
			return LongValue(0), true
		}
		
	case BYTE_OBJ:
		val := obj.(*TByte).Value
		return LongValue(int32(val)), true
	
	case DOUBLE_OBJ:
		val := obj.(*TDouble).Value
		return LongValue(int32(val)), true
	
	case SINGLE_OBJ:
		val := obj.(*TSingle).Value
		return LongValue(int32(val)), true
	
	case INTEGER_OBJ:
		val := obj.(*TInteger).Value
		return LongValue(int32(val)), true
	
	case LONG_OBJ:
		return obj, true
	
	case SHORT_OBJ:
		val := obj.(*TShort).Value
		return LongValue(int32(val)), true
				
	case STRING_OBJ:
		if assign == EXPLICIT {
			if val, err := strconv.Atoi(obj.(*TString).Value); err != nil {
				return LongValue(0), true
			} else {
				return LongValue(int32(val)), true
			}
		}
		
	case UBYTE_OBJ:
		val := obj.(*TUByte).Value
		return LongValue(int32(val)), true
	
	case UINTEGER_OBJ:
		val := obj.(*TUInteger).Value
		return LongValue(int32(val)), true
	
	case ULONG_OBJ:
		val := obj.(*TULong).Value
		return LongValue(int32(val)), true
	
	case USHORT_OBJ:
		val := obj.(*TUShort).Value
		return LongValue(int32(val)), true
	
	default:
		if dobj, ok := Deref(obj); ok {
			return LongObject(dobj, assign)
		}
	}
	
	return nil, false
}


func ShortObject(obj IObject, assign AssignType) (IObject, bool) {
	switch obj.Type() {
		
	case BOOLEAN_OBJ:
		val := obj.(*TBoolean).Value
		if val == true {
			return ShortValue(-1), true
		} else {
			return ShortValue(0), true
		}
			
	case BYTE_OBJ:
		val := obj.(*TByte).Value
		return ShortValue(int16(val)), true
	
	case DOUBLE_OBJ:
		val := obj.(*TDouble).Value
		return ShortValue(int16(val)), true
	
	case SINGLE_OBJ:
		val := obj.(*TSingle).Value
		return ShortValue(int16(val)), true
	
	case INTEGER_OBJ:
		val := obj.(*TInteger).Value
		return ShortValue(int16(val)), true
	
	case LONG_OBJ:
		val := obj.(*TLong).Value
		return ShortValue(int16(val)), true
	
	case SHORT_OBJ:
		return obj, true
				
	case STRING_OBJ:
		if assign == EXPLICIT {
			if val, err := strconv.Atoi(obj.(*TString).Value); err != nil {
				return ShortValue(0), true
			} else {
				return ShortValue(int16(val)), true
			}
		}		
	case UBYTE_OBJ:
		val := obj.(*TUByte).Value
		return ShortValue(int16(val)), true
	
	case UINTEGER_OBJ:
		val := obj.(*TUInteger).Value
		return ShortValue(int16(val)), true
	
	case ULONG_OBJ:
		val := obj.(*TULong).Value
		return ShortValue(int16(val)), true
	
	case USHORT_OBJ:
		val := obj.(*TUShort).Value
		return ShortValue(int16(val)), true
	
	default:
		if dobj, ok := Deref(obj); ok {
			return ShortObject(dobj, assign)
		}
	}
	
	return nil, false
}


func UByteObject(obj IObject, assign AssignType) (IObject, bool) {
	switch obj.Type() {
	case BOOLEAN_OBJ:		
		val := obj.(*TBoolean).Value
		if val == true {
			return UByteValue(1), true
			
		} else {
			return UByteValue(0), true
		}
		
	case BYTE_OBJ:
		val := obj.(*TByte).Value
		return UByteValue(uint8(val)), true
	
	case DOUBLE_OBJ:
		val := obj.(*TDouble).Value
		return UByteValue(uint8(val)), true
	
	case SINGLE_OBJ:
		val := obj.(*TSingle).Value
		return UByteValue(uint8(val)), true
		
	case INTEGER_OBJ:
		val := obj.(*TInteger).Value
		return UByteValue(uint8(val)), true
	
	case LONG_OBJ:
		val := obj.(*TLong).Value
		return UByteValue(uint8(val)), true
	
	case SHORT_OBJ:
		val := obj.(*TShort).Value
		return UByteValue(uint8(val)), true
		
	case STRING_OBJ:
		if assign == EXPLICIT {
			if val, err := strconv.ParseInt(obj.(*TString).Value, 10, 64); err != nil {
				return UByteValue(0), true
			} else {
				return UByteValue(uint8(val)), true
			}
		}
		
	case UBYTE_OBJ:
		return obj, true
	
	case UINTEGER_OBJ:
		val := obj.(*TUInteger).Value
		return UByteValue(uint8(val)), true
	
	case ULONG_OBJ:
		val := obj.(*TULong).Value
		return UByteValue(uint8(val)), true
	
	case USHORT_OBJ:
		val := obj.(*TUShort).Value
		return UByteValue(uint8(val)), true
	
	default:
		if dobj, ok := Deref(obj); ok {
			return UByteObject(dobj, assign)
		}
	}
	
	return nil, false
}


func UIntegerObject(obj IObject, assign AssignType) (IObject, bool) {
	switch obj.Type() {
	case BOOLEAN_OBJ:
		val := obj.(*TBoolean).Value
		if val == true {
			return UIntegerValue(1), true
		} else {
			return UIntegerValue(0), true
		}
		
	case BYTE_OBJ:
		val := obj.(*TByte).Value
		return UIntegerValue(uint64(val)), true
	
	case DOUBLE_OBJ:
		val := obj.(*TDouble).Value
		return UIntegerValue(uint64(val)), true
	
	case SINGLE_OBJ:
		val := obj.(*TSingle).Value
		return UIntegerValue(uint64(val)), true
		
	case INTEGER_OBJ:
		val := obj.(*TInteger).Value
		return UIntegerValue(uint64(val)), true
	
	case LONG_OBJ:
		val := obj.(*TLong).Value
		return UIntegerValue(uint64(val)), true
	
	case SHORT_OBJ:
		val := obj.(*TShort).Value
		return UIntegerValue(uint64(val)), true
		
	case STRING_OBJ:
		if assign == EXPLICIT {
			if val, err := strconv.ParseUint(obj.(*TString).Value, 10, 64); err != nil {
				return UIntegerValue(0), true
			} else {
				return UIntegerValue(val), true
			}
		}
		
	case UBYTE_OBJ:
		val := obj.(*TUByte).Value
		return UIntegerValue(uint64(val)), true
	
	case UINTEGER_OBJ:
		return obj, true
	
	case ULONG_OBJ:
		val := obj.(*TULong).Value
		return UIntegerValue(uint64(val)), true
	
	case USHORT_OBJ:
		val := obj.(*TUShort).Value
		return UIntegerValue(uint64(val)), true
	
	default:
		if dobj, ok := Deref(obj); ok {
			return UIntegerObject(dobj, assign)
		}
	}
	
	return nil, false
}


func ULongObject(obj IObject, assign AssignType) (IObject, bool) {
	switch obj.Type() {
	case BOOLEAN_OBJ:
		val := obj.(*TBoolean).Value
		if val == true {
			return ULongValue(1), true
		} else {
			return ULongValue(0), true
		}
		
	case BYTE_OBJ:
		val := obj.(*TByte).Value
		return ULongValue(uint32(val)), true
	
	case DOUBLE_OBJ:
		val := obj.(*TDouble).Value
		return ULongValue(uint32(val)), true
	
	case SINGLE_OBJ:
		val := obj.(*TSingle).Value
		return ULongValue(uint32(val)), true
		
	case INTEGER_OBJ:
		val := obj.(*TInteger).Value
		return ULongValue(uint32(val)), true
	
	case LONG_OBJ:
		val := obj.(*TLong).Value
		return ULongValue(uint32(val)), true
	
	case SHORT_OBJ:
		val := obj.(*TShort).Value
		return ULongValue(uint32(val)), true
		
	case STRING_OBJ:
		if assign == EXPLICIT {
			if val, err := strconv.ParseInt(obj.(*TString).Value, 10, 64); err != nil {
				return ULongValue(0), true
			} else {
				return ULongValue(uint32(val)), true
			}
		}
	case UBYTE_OBJ:
		val := obj.(*TUByte).Value
		return ULongValue(uint32(val)), true
	
	case UINTEGER_OBJ:
		val := obj.(*TUInteger).Value
		return ULongValue(uint32(val)), true
	
	case ULONG_OBJ:
		return obj, true
	
	case USHORT_OBJ:
		val := obj.(*TUShort).Value
		return ULongValue(uint32(val)), true
	
	default:
		if dobj, ok := Deref(obj); ok {
			return ULongObject(dobj, assign)
		}
	}
	
	return nil, false
}


func UShortObject(obj IObject, assign AssignType) (IObject, bool) {
	switch obj.Type() {
	case BOOLEAN_OBJ:
		val := obj.(*TBoolean).Value
		if val == true {
			return UShortValue(1), true
		} else {
			return UShortValue(0), true
		}
		
	case BYTE_OBJ:
		val := obj.(*TByte).Value
		return UShortValue(uint16(val)), true
	
	case DOUBLE_OBJ:
		val := obj.(*TDouble).Value
		return UShortValue(uint16(val)), true
	
	case SINGLE_OBJ:
		val := obj.(*TSingle).Value
		return UShortValue(uint16(val)), true
		
	case INTEGER_OBJ:
		val := obj.(*TInteger).Value
		return UShortValue(uint16(val)), true
	
	case LONG_OBJ:
		val := obj.(*TLong).Value
		return UShortValue(uint16(val)), true
	
	case SHORT_OBJ:
		val := obj.(*TShort).Value
		return UShortValue(uint16(val)), true
		
	case STRING_OBJ:
		if assign == EXPLICIT {
			if val, err := strconv.ParseInt(obj.(*TString).Value, 10, 64); err != nil {
				return UShortValue(0), true
			} else {
				return UShortValue(uint16(val)), true
			}
		}
		
	case UBYTE_OBJ:
		val := obj.(*TUByte).Value
		return UShortValue(uint16(val)), true
	
	case UINTEGER_OBJ:
		val := obj.(*TUInteger).Value
		return UShortValue(uint16(val)), true
	
	case ULONG_OBJ:
		val := obj.(*TULong).Value
		return UShortValue(uint16(val)), true
	
	case USHORT_OBJ:
		return obj, true
	
	default:
		if dobj, ok := Deref(obj); ok {
			return UShortObject(dobj, assign)
		}
	}
	
	return nil, false
}

