// object/compiled.go

package object

import (
	"fmt"
	"SB/CMP/code"
)

const(
	COMPILED_FUNCTION_OBJ = "COMPILED_FUNCTION"
	COMPILED_SUB_OBJ = "COMPILED_SUB"
)

type TCompiledFunction struct{
	Instructions code.Instructions
	ReturnType IObject
	NumLocals int
	NumParameters int
}

func(cf *TCompiledFunction) Type() ObjectType { return COMPILED_FUNCTION_OBJ }
func(cf *TCompiledFunction) Inspect() string{
	return fmt.Sprintf("CompiledFunction[%p]", cf)
}


type TCompiledSub struct{
	Instructions code.Instructions
	NumLocals int
	NumParameters int
}

func(cs *TCompiledSub) Type() ObjectType { return COMPILED_SUB_OBJ }
func(cs *TCompiledSub) Inspect() string{
	return fmt.Sprintf("CompiledSub[%p]", cs)
}

