// object/assign.go

package object

import (
	"strconv"
)

type AssignType uint8

var IMPLICIT, EXPLICIT AssignType = 0, 1


func AssignString(arg IObject, assign AssignType) (IObject, bool) {
	switch arg.(type) {
	case *TBoolean:
		if assign == EXPLICIT {
			str := "false"
			if arg.(*TBoolean).Value == true {
				str = "true"
			}
			return &TString { Value: str }, true
		}
		
	case *TByte:
		if assign == EXPLICIT {
			str := strconv.FormatInt(int64(arg.(*TByte).Value), 10)
			return &TString { Value: str }, true
		}	
			
	case *TDouble:
		if assign == EXPLICIT {
			str := strconv.FormatFloat(arg.(*TDouble).Value, 'f', -1, 64)
			return &TString { Value: str }, true
		}
		
	case *TSingle:
		if assign == EXPLICIT {
			str := strconv.FormatFloat(float64(arg.(*TSingle).Value), 'f', -1, 32)
			return &TString { Value: str }, true
		}
		
	case *TInteger:
		if assign == EXPLICIT {
			str := strconv.FormatInt(arg.(*TInteger).Value, 10)
			return &TString { Value: str }, true
		}
		
	case *TLong:
		if assign == EXPLICIT {
			str := strconv.FormatInt(int64(arg.(*TLong).Value), 10)
			return &TString { Value: str }, true
		}
	
	case *TReference:
		val := arg.(*TReference).Value
		return AssignString(val, assign)
		
	case *TShort:
		if assign == EXPLICIT {
			str := strconv.FormatInt(int64(arg.(*TShort).Value), 10)
			return &TString { Value: str }, true
		}
	case *TString:
		return &TString { arg.(*TString).Value }, true
		
	case *TUByte:
		if assign == EXPLICIT {
			str := strconv.FormatUint(uint64(arg.(*TUByte).Value), 10)
			return &TString { Value: str }, true
		}
		
	case *TUInteger:
		if assign == EXPLICIT {
			str := strconv.FormatUint(arg.(*TUInteger).Value, 10)
			return &TString { Value: str }, true
		}
		
	case *TULong:
		if assign == EXPLICIT {
			str := strconv.FormatUint(uint64(arg.(*TULong).Value), 10)
			return &TString { Value: str }, true
		}
		
	case *TUShort:
		if assign == EXPLICIT {
			str := strconv.FormatUint(uint64(arg.(*TUShort).Value), 10)
			return &TString { Value: str }, true
		}
	}
	
	return nil, false
}


func AssignDefault(lhs, rhs IObject) (IObject, bool) {
	var result IObject
	
	switch lhs.(type) {
	case *TBoolean:
		result,_ = BooleanObject(rhs, IMPLICIT)
	case *TByte:
		result,_ = ByteObject(rhs, IMPLICIT)
	case *TDouble:
		result,_ = DoubleObject(rhs, IMPLICIT)
	case *TSingle:
		result,_ = SingleObject(rhs, IMPLICIT)
	case *TInteger:
		result,_ = IntegerObject(rhs, IMPLICIT)
	case *TLong:
		result,_ = LongObject(rhs, IMPLICIT)
	case *TShort:
		result,_ = ShortObject(rhs, IMPLICIT)
	case *TString:
		result,_ = AssignString(rhs, IMPLICIT)
	case *TUByte:
		result,_ = UByteObject(rhs, IMPLICIT)
	case *TUInteger:
		result,_ = UIntegerObject(rhs, IMPLICIT)
	case *TULong:
		result,_ = ULongObject(rhs, IMPLICIT)
	case *TUShort:
		result,_ = UShortObject(rhs, IMPLICIT)
	case *TFunction:
		if _, ok := rhs.(*TFunction); ok {
			fobj := lhs.(*TFunction)
			// must be null-function object
			if fobj.Literal == nil {
				result = rhs	
			}
		}
	case *TNull:
		result = rhs;
	}
	
	flag := (result != nil)
	
	return result, flag
}

