func (p *TParser) parseSelectExpression() ast.IExpression {
	se := &ast.TSelectExpression { Token: p.curToken }
	se.Cases = []ast.IStatement{}

	p.nextToken()
	
	se.Expression = p.parseExpression(LOWEST)
	
	if !p.expectPeek(token.DO) {
		return nil
	}
	
	p.nextToken()
	
	var def *ast.TDefaultBlock
	
	for !p.curTokenIs(token.END) {
		switch p.curToken.Type {
		case token.CASE:
			cas := &ast.TCaseBlock { Token: p.curToken }
			
			p.nextToken()
			
			//caseCollect:
			for {
				exp := p.parseExpression(LOWEST)
				
				if exp == nil {
					break //caseCollect
				}
								
				if _, ok := exp.(*ast.TFromToExpression); ok {
					exp.(*ast.TFromToExpression).Context = token.SELECT
				}
				
				cas.Expressions = append(cas.Expressions, exp)
				
				if p.peekToken.Type == token.COMMA {
					p.nextToken()
					p.nextToken()
				} else {
					break //caseCollect
				}
			}
			
			cas.Block = p.parseBlockStatement(token.COLON, token.CASE, token.DEFAULT, token.END)
			if cas.Block != nil {
				se.Cases = append(se.Cases, cas)
			}
			
		case token.DEFAULT:
			// default:
			if def == nil {
				def = &ast.TDefaultBlock { Token: p.curToken }
				se.Cases = append(se.Cases, def)
				def.Block = p.parseBlockStatement(token.COLON, token.CASE, token.END, "")
			} else {
				msg := fmt.Sprintf("Syntax Error: duplicate %s in %s block.", token.DEFAULT, token.SELECT)
				p.errors = append(p.errors, msg)
				return nil
			}
		default:
			msg := fmt.Sprintf("Syntax Error: expected %s or %s, got %s instead.", token.CASE, token.END, p.curToken.Type)
			p.errors = append(p.errors, msg)
			return nil
		}
	}
	
	return se
}