type TSelectExpression struct {
	Token        token.TToken
	Expression	IExpression
	Cases				[]IStatement
}

func (se *TSelectExpression) expressionNode() {}
func (se *TSelectExpression) TokenLiteral() string { return se.Token.Literal }
func (se *TSelectExpression) String() string {
	var out bytes.Buffer

	out.WriteString("select ")
	out.WriteString(se.Expression.String())
	out.WriteString(" do\n")
	
	cases := []string{}
	
	for _, i := range se.Cases {
		cases = append(cases, i.String())
	}

	out.WriteString(strings.Join(cases, " "))
	out.WriteString(" end\n")
	
	return out.String()
}

type TCaseBlock struct {
	Token					token.TToken
	Block					*TBlockStatement
	Expressions		[]IExpression
}

func (cb *TCaseBlock) statementNode() {}
func (cb *TCaseBlock) TokenLiteral() string { return cb.Token.Literal }
func (cb *TCaseBlock) String() string {
	var out bytes.Buffer
	
	out.WriteString(cb.Block.String())
	
	return out.String()
}

type TDefaultBlock struct {
	Token		token.TToken
	Block		*TBlockStatement
}

func (db *TDefaultBlock) statementNode() {}
func (db *TDefaultBlock) TokenLiteral() string { return db.Token.Literal }
func (db *TDefaultBlock) String() string {
	var out bytes.Buffer
	
	out.WriteString(db.Block.String())
	
	return out.String()
}

type TFromToExpression struct {
	Token				token.TToken
	Expression	IExpression
	Context			token.TokenType
}

func (ft *TFromToExpression) expressionNode() {}
func (ft *TFromToExpression) TokenLiteral() string { return ft.Token.Literal }
func (ft *TFromToExpression) String() string {
	var out bytes.Buffer
	
	out.WriteString(ft.Expression.String())
	
	return out.String()
}
