// sb.go
package main

import (
	"fmt"
	"os"
	"io/ioutil"
	"SB/lexer"
	"SB/parser"
	"SB/object"
	"SB/INT/repl"
)


func runProgram(filename string) {
	wd, err := os.Getwd()
	if err != nil {
		fmt.Println(err.Error())
		os.Exit(1)
	}
	
	f, err := ioutil.ReadFile(wd + "/" + filename)
	if err != nil {
		fmt.Println("SharpBASIC: ", err.Error())
		os.Exit(1)
	}
	
	l := lexer.New(string(f))
	p := parser.New(l)
	
	program := p.ParseProgram()
	if len(p.Errors()) != 0 {
		for _, err := range p.Errors() {
			fmt.Println(err)
		}
		os.Exit(1)
	}
	
	scope := object.NewScope(nil)
	result := object.Eval(program, scope)
	if result != nil {
		fmt.Println(result.Inspect())
	}	
}


func main() {
	args := os.Args[1:]
	os.Args = os.Args[1:] // must reset
	if len(args) == 0 {
		fmt.Println("SharpBASIC programming language REPL\n")
		repl.Start(os.Stdin, os.Stdout)
	} else {
		runProgram(args[0])
	}
}

