// repl/repl.go

package repl

import (
	"bufio"
	"fmt"
	"io"
	//"SB/token"
	"SB/lexer"
	"SB/parser"
	"SB/object"
)

const PROMPT = "SharpBASIC:>"

func Start(in io.Reader, out io.Writer) {
	scanner := bufio.NewScanner(in)
	scope := object.NewScope(nil)
	
	for {
		fmt.Printf(PROMPT)
		scanned := scanner.Scan()
		if !scanned { return }
		
		line := scanner.Text()
		if len(line) == 0 { break }
		
		l := lexer.New(line)
		p := parser.New(l)
		
		program := p.ParseProgram()
		if len(p.Errors()) != 0 {
			printParserErrors(out, p.Errors())
			break
		}
		
		ev := object.Eval(program, scope)
		if err, ok := ev.(*object.TError); ok {
			io.WriteString(out, err.Inspect())
			io.WriteString(out, "\n")
		}
	}
}

func printParserErrors(out io.Writer, errors []string) {
	for _, msg := range errors {
		io.WriteString(out, "\t" + msg + "\n")
	}
}

