// vm/frame.go

package vm

import (
	"SB/object"
	"SB/CMP/code"
)


type TFrame struct {
	fn	*object.TCompiledFunction
	bp	int
	ip	int
}


func NewFrame(cf *object.TCompiledFunction, bp int) *TFrame {
	f := &TFrame {
		fn: cf,
		bp: bp,
		ip: -1,
	}

	return f
}


func (f *TFrame) Instructions() code.Instructions {
	return f.fn.Instructions
}

