// repl/repl.go

package repl

import (
	"bufio"
	"fmt"
	"io"
	"SB/lexer"
	"SB/parser"
	"SB/object"
	"SB/CMP/compiler"
	"SB/CMP/vm"
)

const PROMPT = "SharpBASIC:>"

func Start(in io.Reader, out io.Writer) {
	scanner := bufio.NewScanner(in)
	
	// tmp test:
	constants := []object.IObject{}
	globals := make([]object.IObject, vm.GlobalsSize)
	symbolTable := compiler.NewSymbolTable()
	
	for i, v := range object.Builtins {
		symbolTable.DefineBuiltin(i, v.Name)
	}
	
	for {
		fmt.Printf(PROMPT)
		scanned := scanner.Scan()
		if !scanned {
			return
		}

		line := scanner.Text()
		if len(line) == 0 {
			return
		}
		
		l := lexer.New(line)
		p := parser.New(l)

		program := p.ParseProgram()
		if len(p.Errors()) != 0 {
			printParserErrors(out, p.Errors())
			continue
		}
		
		// tmp test
		comp := compiler.NewWithState(symbolTable, constants)
		//comp := compiler.New()
		
		err := comp.Compile(program)
		if err != nil {
			fmt.Fprintf(out, "Compilation failed:\n%s\n", err)
			continue
		}
		
		// tmp test
		code := comp.Bytecode()
		constants = code.Constants
		machine := vm.NewWithGlobalsStore(code, globals)
		//machine := vm.New(comp.Bytecode())
		
		result := machine.Run()
		if result != nil {
			// fmt.Fprintf(out, "Executing bytecode failed:\n%s\n", err)
			fmt.Println(result.Inspect())
			continue
		}
		/*
		lastPopped := machine.LastPoppedStackElem()
		if lastPopped != nil {
			io.WriteString(out, lastPopped.Inspect())
			io.WriteString(out, "\n")
		}
		*/
	}
}

func printParserErrors(out io.Writer, errors []string) {
	for _, msg := range errors {
		io.WriteString(out, "\t" + msg + "\n")
	}
}
