import scipy
import numpy as np
import matplotlib.pyplot as plt
from numpy.lib.stride_tricks import as_strided

# (1)
x = np.arange(10, dtype=np.int32)
x_window = as_strided(x,
                      shape=(len(x) - 3 + 1, 3),
                      strides=(x.itemsize, x.itemsize))
print x_window

# (2)
img = scipy.lena()
img += 0.8 * img.std() * np.random.rand(*img.shape)

window_size = 5
shape = (img.shape[0] - window_size + 1,
         img.shape[1] - window_size + 1,
         window_size, window_size)
strides = (img.shape[1]*img.itemsize, img.itemsize,
           img.shape[1]*img.itemsize, img.itemsize)

img_window = as_strided(img, shape=shape, strides=strides)
img_median = np.median(img_window.reshape(shape[0], shape[1],
                                          window_size*window_size),
                       axis=-1)

plt.subplot(121)
plt.imshow(img)
plt.gray()
plt.subplot(122)
plt.imshow(img_median)
plt.gray()
plt.show()
