import numpy as np

def index(indices, data, strides, dtype):
    byte_offset = sum(np.asarray(indices) * strides)
    return data[byte_offset:byte_offset + dtype.itemsize]

a = np.array([[1, 2, 3], [4, 5, 6]], dtype=np.int16)
b = a.T

assert index([1, 1], str(a.data), a.strides, a.dtype) == str(a[1,1].data)
assert index([1, 1], str(b.data), b.strides, b.dtype) == str(b[1,1].data)
