import numpy as np

word_dtype = np.dtype([
    ('rank', int),
    ('lemma', 'S10'),
    ('frequency', int),
    ('dispersion', float)
])

# Load data from file
data = np.loadtxt('words.txt', dtype=word_dtype, comments='%')

# Print words, the 3rd row, and all words with low rank
print "Words:", data['lemma']
print "3rd row:", data[2]
print "Low-rank words:", data['lemma'][data['rank'] < 30]

# Sort (in-place)
data.sort(order='frequency')
print data

# Save to Numpy data file
np.savez('sorted.npz', data=data)

# Load from there
loaded_data = np.load('sorted.npz')

# Compare
assert np.all(data == loaded_data['data'])

# Save to text file
np.savetxt('sorted.txt', data, fmt='%d %s %d %g')
