import numpy as np

def part_1():
    print "**** Part 1 ****"

    a = np.array([[1, 2, 3], [4, 5, 6]], dtype=np.int16)

    # The transpose is implemented by just swapping the strides of an array 
    assert a.T.strides == (a.strides[1], a.strides[0])

    # Reversing elements changes the sign of the strides (and moves
    # the start point of the array).
    assert a[::-1].strides == (-a.strides[0], a.strides[1])

    print "OK"

def part_2():
    print "**** Part 2 ****"

    a = np.array([[1, 2], [3, 4]], dtype=np.byte)
    b = a.T

    assert a.flags.c_contiguous
    assert not b.flags.c_contiguous

    # C-contiguous: data elements are immediately after each other in memory
    # so that every byte in the memory block belongs to some array element.
    #
    # Moreover, the strides are in **decreasing** order
    assert tuple(a.strides) == tuple(sorted(a.strides)[::-1])

    print "OK"

if __name__ == "__main__":
    part_1()
    part_2()

