import numpy as np

def part_1():
    print "**** Part 1 ****"

    a = np.random.rand(5, 6)
    means = a.mean()

    row_min = a.min(axis=1)
    column_max = a.max(axis=0)
    
    int_mul_a = (10*a).astype(int)

    print a
    print row_min
    print column_max
    print int_mul_a

def part_2():
    print "**** Part 2 ****"

    x1 = np.array([1, 2, 3, 4]) / 2  # Integer division, rounds down/truncates
    x2 = np.array([1.0, 2, 3, 4]) / 2  # Float division, no rounding
    x3 = np.array([1, 2, 3, 4]) // 2  # Integer division again
    x4 = np.array([1.0, 2, 3, 4]) // 2  # Division with rounding down

    # This is a float array, so same as x2
    a = np.array([1, 2, 3, 4], dtype=float)

    # This is a integer array, so same as x1
    b = np.array([1, 2, 3, 4], dtype=np.int8)

def part_3():
    print "**** Part 3 ****"

    a = np.array([[1, 2, 3], [4, 5, 6]])

    # This uses fancy indexing, so the result owns its data (is a copy)
    #
    # However, there is a temporary array that owns the data, so the .flags
    # attribute needs to be used carefully
    b = a[:,[0,1]]
    assert b.base is not a
    assert b.base.flags.owndata

    # This uses slicing, so the result does not owns its data (is a view)
    assert not a[:,0:2].flags.owndata

    # Slicing (the two lines below are equivalent, the last slice is optional)
    assert not a[0].flags.owndata
    assert not a[0,:].flags.owndata

    # Transpose can also implemented with strides, so it's a view
    assert not a.T.flags.owndata

    # Uh-oh -- the following two are **not** the same 
    x1 = a[[True, False]]
    x2 = a[np.array([True, False])]
    assert np.any(x1 != x2)

    # But the following two are
    x3 = a[[True, False]]
    x4 = a[[1, 0]]
    assert np.all(x3 == x4)

    # All of them are copies, though
    assert x1.flags.owndata
    assert x2.flags.owndata
    assert x3.flags.owndata
    assert x4.flags.owndata

    # The moral of the story seems to be that boolean indexing only occurs with
    # boolean arrays.
    #
    # To be fair, the documentation does state::
    #
    #    """This advanced indexing occurs when obj is an array object of
    #    Boolean type"""
    #
    #    http://docs.scipy.org/doc/numpy/reference/arrays.indexing.html
    #

    # *** Bonus sector***

    # This one is a trick question: .reshape() returns a view **if it
    # is possible** to represent the result using strides. Otherwise,
    # one gets a copy.

    # The rule of thumb is that if you are reducing the number of dimensions,
    # copies may happen.

    # This one is a view
    assert not a.reshape(2*3).flags.owndata
    
    # However, the copy is made with a temporary array:
    b = a.T
    c = b.reshape(2*3)
    assert not c.flags.owndata
    assert c.base is not b          # c.base is a temporary array!
    assert c.base.flags.owndata
    
def change_it(x):
    x[:] = np.array([7, 8, 9])

def part_4():
    print "**** Part 4 ****"

    a = np.array([1, 2, 3, 4, 5, 6])
    change_it(a[1:4])
    print a

if __name__ == "__main__":
    part_1()
    part_2()
    part_3()
    part_4()
