/*
 * Copyright 2012 Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "phenom/thread.h"
#include "phenom/sysutil.h"

const char *ph_strerror_r(int errval, char *buf, size_t len)
{
#ifdef __linux__
  /* Since we defined _GNU_SOURCE, we get the GNU-style version
   * of this function */
  return strerror_r(errval, buf, len);
#elif defined(HAVE_STRERROR_R)
  strerror_r(errval, buf, len);
  return buf;
#else
  return strerror(errval);
#endif
}

const char *ph_strerror(int errval)
{
  ph_thread_t *me = ph_thread_self();
  return ph_strerror_r(errval,
      me->strerror_buf, sizeof(me->strerror_buf));
}


/* vim:ts=2:sw=2:et:
 */

