/*
 * Copyright 2013-present Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef CORELIB_COUNTER_H
#define CORELIB_COUNTER_H

struct ph_counter_scope {
  ph_refcnt_t refcnt;
  uint32_t scope_id;
  unsigned long hash; // NOLINT(runtime/int)

  uint8_t num_slots, next_slot;
  /* points to just after slot_names */
  char *scope_name;
  char *full_scope_name;

  /* variable size array; the remainder of this struct
   * holds num_slots elements */
  char *slot_names[1];
};


#endif

/* vim:ts=2:sw=2:et:
 */

