package com.trumphurst.utils;

/**
 * Error handler to handle errors when loading a TProperties from a stream.
 * @see trumphurst.utils.TProperties#load
 * @see trumphurst.utils.TProperties#fullload
 */
public interface ValidationExceptionHandler {
	static RCSVersion version = new RCSVersion("$Id: ValidationExceptionHandler.java 1.2 1997/09/19 17:09:12 nikki Exp nikki $");
	/**
	 * Method called for each exception encountered.
	 * @param setcmd the command line causing the exception
	 * @param key the key parsed from setcmd
	 * @param value the value parsed from setcmd
	 * @param classname the classname parsed from setcmd (if any)
	 * @param arguments the arguments parsed from setcmd (if any)
	 * @param e the exception thrown
	 * @return <DL>
	 * <DT>Null, or the original line
	 * <DD>The original property is replaced with a TStringProperty containing the value
	 * <DT>A string starting with ";", or an invalid command line
	 * <DD>The original property is left unchanged
	 * <DT>A different valid command line
	 * <DD>The new command line is reparsed and reprocessed</DL>
	 * @see trumphurst.utils.TProperties#load
	 * @see trumphurst.utils.TProperties#fullload
	 */
	public String handleException(String setcmd, String key,
		String value, String classname, String arguments, Exception e);
}
