import com.trumphurst.utils.*;
import java.util.*;
import java.io.*;

public class Test {
	static RCSVersion version = new RCSVersion("$Id: Test.java 1.2 1997/09/19 17:09:18 nikki Exp nikki $");
	final static int maxitems = 1000;
	final static int power = 1000000;
	static long start;

	public static void main(String args[]) {
		if(args.length == 0) {
			Random r;

			args = new String[maxitems];
			for(int i = 0; i < maxitems; i++) {
				int x = r.nextInt();

				if(x < 0)
					x = -x;
				args[i] = String.valueOf(x % power + power).substring(1);
			}

		}
		
		PatriciaTree tree = new PatriciaTree();

		System.out.println("PatriciaTree");
		testDictionary(args, tree);
		tree = null;
		System.gc();

		Hashtable hash = new Hashtable();

		System.out.println("Hashtable");
		testDictionary(args, hash);
		hash = null;
		System.gc();
		presscr();
	}

	static void testDictionary(String args[], Dictionary d) {
		startTimer();
		for(int i = 0; i < args.length; i++) {
			d.put(args[i], args[i]);
		}
		stopTimer("Add");

		startTimer();
		Enumeration e = d.keys();

		while(e.hasMoreElements())
			e.nextElement();
		stopTimer("Enumerate");

		startTimer();
		for(int i = 0; i < args.length; i++)
			d.get(args[i]);
		stopTimer("Access");
	}

	static void startTimer() {
		start = System.currentTimeMillis();
	}

	static void stopTimer(String test) {
		start = System.currentTimeMillis() - start;
		System.out.println(test + ":" + start);
	}

	static void presscr() {
		try {
			System.out.print("Press return:");
			System.out.flush();
			while(System.in.read() != '\n')
				;
		} catch(IOException io) {
		}
	}

}

