package com.trumphurst.utils;

/** A TProperty which holds a String value */
public class TStringProperty implements TProperty {
	static RCSVersion version = new RCSVersion("$Id: TStringProperty.java 1.2 1997/09/19 17:09:27 nikki Exp nikki $");
	/** The value */
	protected String s;

	/**
	 * Construct with a value
	 * @param s the value
	 */
	public TStringProperty(String s) {
		this.s = s;
	}

	/** Return the value */
	public String get() {
		return s;
	}

	/**
	 * Return the String value of the specified property in the properties list.
	 * Verifies that the key exists, and refers to a TStringProperty (or a
	 * subclass).
	 * @param properties the properties list
	 * @key the key to look up
	 * @return the String value of the property, or null
	 */
	public static String get(TProperties properties, String key) {
		TProperty p = properties.get(key);
		if(p != null && p instanceof TStringProperty)
			return ((TStringProperty)p).get();
		return null;
	}

	/** 
	 * Set the value 
	 * @param s the value to set
	 * @exception ValidationException never thrown by this class, but a
	 * subclass that only permits a limited range of values might throw
	 * the exception if the new value was out of range.
	 */
	public void set(String s) throws ValidationException {
		this.s = s;
	}

	/**
	 * "Construct" the property from a String argument list.
	 * The same as fromString, as there are no additional arguments other
	 * than the value.
	 * @param arguments a string
	 * @exception ValidationException never thrown by this class, but a
	 * subclass that only permits a limited range of values might throw
	 * the exception if the new value was out of range.
	 */
	public void construct(String arguments) throws ValidationException {
		fromString(arguments);
	}

	/**
	 * Change the value of the property from a String representation of the new value.
	 * @param arguments a string
	 * @exception ValidationException never thrown by this class, but a
	 * subclass that only permits a limited range of values might throw
	 * the exception if the new value was out of range.
	 */
	public void fromString(String s) throws ValidationException {
		set(s);
	}

	/**
	 * Return a String representation of the value.
	 * @return the String
	 */
	public String toString() {
		return s;
	}

	/**
	 * Return a String representation of the arguments necessary to construct the property.
	 * @return the String
	 */
	public String arguments() {
		return toString();
	}

	/** Empty constructor used immediately before <B>construct</B> is called */
	TStringProperty() {
	}
}
