package com.trumphurst.utils;

import java.util.*;

/** A TProperty which holds a long value limited to a range */
public class TRangeLongProperty extends TLongProperty {
	static RCSVersion version = new RCSVersion("$Id: TRangeLongProperty.java 1.2 1997/09/19 17:09:25 nikki Exp nikki $");
	/** The lowest permitted value in the range */
	protected long low;
	/** The highest permitted value in the range */
	protected long high;

	/**
	 * Construct with a value and range
	 * @param l the value
	 * @param low the lowest permissible value
	 * @param high the highest permissible value
	 * @exception ValidationException if l < low or l > high
	 */
	public TRangeLongProperty(long l, long low, long high) throws ValidationException {
		this.low = low;
		this.high = high;
		set(l);
	}

	/** 
	 * Set the value 
	 * @param l the value to set
	 * @exception ValidationException if l < low or l > high
	 */
	public void set(long l) throws ValidationException {
		if(l < low || l > high)
			throw new ValidationException("not between " + low + " and " + high);
		this.l = l;
	}

	/**
	 * "Construct" the property from a String argument list.
	 * @param arguments a string of the form "1,0,2" representing "value,low,high"
	 * @exception ValidationException if the arguments cannot be parsed, or
	 * the value is outside the specified range.
	 */
	public void construct(String arguments) throws ValidationException {
		try {
			StringTokenizer t = new StringTokenizer(arguments, ", \t\r\n");
			long l = Long.parseLong(t.nextToken());
			low = Long.parseLong(t.nextToken());
			high = Long.parseLong(t.nextToken());
			set(l);
		}
		catch(NumberFormatException nf) {
			throw new ValidationException("not a long");
		}
		catch(NoSuchElementException nse) {
			throw new ValidationException("not enough arguments");
		}
	}

	/**
	 * Return a String representation of the arguments necessary to construct the property.
	 * @return a string of the form "1,0,2" representing "value,low,high"
	 */
	public String arguments() {
		return toString() + "," + low + "," + high;
	}

	/** Empty constructor used immediately before <B>construct</B> is called */
	TRangeLongProperty() {
	}
}
