package com.trumphurst.utils;

import java.util.*;

/** A TProperty which holds an int value limited to a range */
public class TRangeIntegerProperty extends TIntegerProperty {
	static RCSVersion version = new RCSVersion("$Id: TRangeIntegerProperty.java 1.2 1997/09/19 17:09:24 nikki Exp nikki $");
	/** The lowest permitted value in the range */
	protected int low;
	/** The highest permitted value in the range */
	protected int high;

	/**
	 * Construct with a value and range
	 * @param i the value
	 * @param low the lowest permissible value
	 * @param high the highest permissible value
	 * @exception ValidationException if i < low or i > high
	 */
	public TRangeIntegerProperty(int i, int low, int high) throws ValidationException {
		this.low = low;
		this.high = high;
		set(i);
	}

	/** 
	 * Set the value 
	 * @param i the value to set
	 * @exception ValidationException if i < low or i > high
	 */
	public void set(int i) throws ValidationException {
		if(i < low || i > high)
			throw new ValidationException("not between " + low + " and " + high);
		this.i = i;
	}

	/**
	 * "Construct" the property from a String argument list.
	 * @param arguments a string of the form "1,0,2" representing "value,low,high"
	 * @exception ValidationException if the arguments cannot be parsed, or
	 * the value is outside the specified range.
	 */
	public void construct(String arguments) throws ValidationException {
		try {
			StringTokenizer t = new StringTokenizer(arguments, ", \t\r\n");
			int i = Integer.parseInt(t.nextToken());
			low = Integer.parseInt(t.nextToken());
			high = Integer.parseInt(t.nextToken());
			set(i);
		}
		catch(NumberFormatException nf) {
			throw new ValidationException("not an integer");
		}
		catch(NoSuchElementException nse) {
			throw new ValidationException("not enough arguments");
		}
	}

	/**
	 * Return a String representation of the arguments necessary to construct the property.
	 * @return a string of the form "1,0,2" representing "value,low,high"
	 */
	public String arguments() {
		return toString() + "," + low + "," + high;
	}

	/** Empty constructor used immediately before <B>construct</B> is called */
	TRangeIntegerProperty() {
	}
}
