package com.trumphurst.utils;

import java.util.*;

/** A TProperty which holds a double value limited to a range */
public class TRangeDoubleProperty extends TDoubleProperty {
	static RCSVersion version = new RCSVersion("$Id: TRangeDoubleProperty.java 1.2 1997/09/19 17:09:22 nikki Exp nikki $");
	/** The lowest permitted value in the range */
	protected double low;
	/** The highest permitted value in the range */
	protected double high;

	/**
	 * Construct with a value and range
	 * @param d the value
	 * @param low the lowest permissible value
	 * @param high the highest permissible value
	 * @exception ValidationException if d < low or d > high
	 */
	public TRangeDoubleProperty(double d, double low, double high) throws ValidationException {
		this.low = low;
		this.high = high;
		set(d);
	}

	/** 
	 * Set the value 
	 * @param d the value to set
	 * @exception ValidationException if d < low or d > high
	 */
	public void set(double d) throws ValidationException {
		if(d < low || d > high)
			throw new ValidationException("not between " + low + " and " + high);
		this.d = d;
	}

	/**
	 * "Construct" the property from a String argument list.
	 * @param arguments a string of the form "1.0,0.0,2.0" representing "value,low,high"
	 * @exception ValidationException if the arguments cannot be parsed, or
	 * the value is outside the specified range.
	 */
	public void construct(String arguments) throws ValidationException {
		try {
			StringTokenizer t = new StringTokenizer(arguments, ", \t\r\n");
			double d = Double.valueOf(t.nextToken()).doubleValue();
			low = Double.valueOf(t.nextToken()).doubleValue();
			high = Double.valueOf(t.nextToken()).doubleValue();
			set(d);
		}
		catch(NumberFormatException nf) {
			throw new ValidationException("not a double");
		}
		catch(NoSuchElementException nse) {
			throw new ValidationException("not enough arguments");
		}
	}

	/**
	 * Return a String representation of the arguments necessary to construct the property.
	 * @return a string of the form "1.0,0.0,2.0" representing "value,low,high"
	 */
	public String arguments() {
		return toString() + "," + low + "," + high;
	}

	/** Empty constructor used immediately before <B>construct</B> is called */
	TRangeDoubleProperty() {
	}
}
