package com.trumphurst.utils;

/**
 * The base interface for all properties added to a TProperties.
 * Should also have an the following members/constructors ...<UL>
 * <LI>An empty constructor accessable from the trumphurst.utils package.
 * <LI>A constructor to construct the property with an initial value and
 * and range or other validation limits. Some such constructors may throw
 * a ValidationException if the initial value provided is unsuitable.
 * <LI>A get method which returns an appropriate value (e.g. int for an 
 * integer property).
 * <LI>A <B>static</B> get method which takes as arguments a TProperties
 * and a key, and which looks up the key, validates that the returned TProperty
 * is the correct class (i.e. this class, or a subclass of this class), 
 * extracts the value, and returns it. If the property does not exist, or is
 * the wrong type, a suitable default value should be returned.
 * <LI>A set method which takes an appropriate value. Some such set methods
 * may throw a ValidationException if the value provided is unsuitable.
 * @see trumphurst.utils.Tproperties
 */
public interface TProperty {
	static RCSVersion version = new RCSVersion("$Id: TProperty.java 1.2 1997/09/19 17:09:22 nikki Exp nikki $");
	/**
	 * "Construct" the property from a String argument list.
	 * The argument list is of exactly the same form as the return value of the
	 * arguments method.
	 * @param arguments a String representing the arguments.
	 * By convention, the argument list consists of individual
	 * arguments, separated by commas (',') - the first argument
	 * is the value, and subsequent arguments are any additional
	 * data needed for the class (e.g. the low and high values
	 * for a range validation class).
	 * @exception ValidationException when the value in the argument 
	 * list is invalid for the property, or the argument list is invalid.
	 * @see trumphurst.utils.TProperty#arguments
	 */
	void construct(String arguments) throws ValidationException;
	/**
	 * Change the value of the property from a String representation of the new value.
	 * @param value a String representation of the new value
	 * @exception ValidationException when the value is not a valid value for the property
	 * @see trumphurst.utils.TProperty#toString
	 */
	public void fromString(String value) throws ValidationException;
	/**
	 * Return a String representation of the value.
	 * The String returned should be suitable to use in a call to the fromString method.
	 * @return a String representation of the value
	 * @see trumphurst.utils.fromString
	 */
	public String toString();
	/**
	 * Return a String representation of the arguments necessary to construct the property.
	 * The String returned should be suitable for use in a call to the construct method.
	 * @return a String representation of the arguments necessary to construct the property
	 * @see trumphurst.utils.construct
	 */
	public String arguments();
}
