package com.trumphurst.utils;

/** A TProperty which holds a long value */
public class TLongProperty implements TProperty {
	static RCSVersion version = new RCSVersion("$Id: TLongProperty.java 1.2 1997/09/19 17:09:20 nikki Exp nikki $");
	/** The value */
	protected long l;

	/**
	 * Construct with a value
	 * @param l the value
	 */
	public TLongProperty(long l) {
		this.l = l;
	}

	/** Return the value */
	public long get() {
		return l;
	}

	/**
	 * Return the long value of the specified property in the properties list.
	 * Verifies that the key exists, and refers to a TLongProperty (or a
	 * subclass).
	 * @param properties the properties list
	 * @key the key to look up
	 * @return the long value of the property, or 0
	 */
	public static long get(TProperties properties, String key) {
		TProperty p = properties.get(key);
		if(p != null && p instanceof TLongProperty)
			return ((TLongProperty)p).get();
		return 0;
	}

	/** 
	 * Set the value 
	 * @param l the value to set
	 * @exception ValidationException never thrown by this class, but a
	 * subclass that only permits a limited range of values might throw
	 * the exception if the new value was out of range.
	 */
	public void set(long l) throws ValidationException {
		this.l = l;
	}

	/**
	 * "Construct" the property from a String argument list.
	 * The same as fromString, as there are no additional arguments other
	 * than the value.
	 * @param arguments a string which can be converted into a long
	 * @exception ValidationException if the argument cannot be converted to a long
	 */
	public void construct(String arguments) throws ValidationException {
		fromString(arguments);
	}

	/**
	 * Change the value of the property from a String representation of the new value.
	 * @param arguments a string which can be converted into a long
	 * @exception ValidationException if the argument cannot be converted to a long
	 */
	public void fromString(String s) throws ValidationException {
		try {
			set(Long.parseLong(s));
		}
		catch(NumberFormatException nf) {
			throw new ValidationException("not a long");
		}
	}

	/**
	 * Return a String representation of the value.
	 * @return the long converted to a String
	 */
	public String toString() {
		return String.valueOf(l);
	}

	/**
	 * Return a String representation of the arguments necessary to construct the property.
	 * @return the long converted to a String
	 */
	public String arguments() {
		return toString();
	}

	/** Empty constructor used immediately before <B>construct</B> is called */
	TLongProperty() {
	}
}
