package com.trumphurst.utils;

/** A TProperty which holds an int value */
public class TIntegerProperty implements TProperty {
	static RCSVersion version = new RCSVersion("$Id: TIntegerProperty.java 1.2 1997/09/19 17:09:19 nikki Exp nikki $");
	/** The value */
	protected int i;

	/**
	 * Construct with a value
	 * @param i the value
	 */
	public TIntegerProperty(int i) {
		this.i = i;
	}

	/** Return the value */
	public int get() {
		return i;
	}

	/**
	 * Return the int value of the specified property in the properties list.
	 * Verifies that the key exists, and refers to a TIntegerProperty (or a
	 * subclass).
	 * @param properties the properties list
	 * @key the key to look up
	 * @return the int value of the property, or 0
	 */
	public static int get(TProperties properties, String key) {
		TProperty p = properties.get(key);
		if(p != null && p instanceof TIntegerProperty)
			return ((TIntegerProperty)p).get();
		return 0;
	}

	/** 
	 * Set the value 
	 * @param i the value to set
	 * @exception ValidationException never thrown by this class, but a
	 * subclass that only permits a limited range of values might throw
	 * the exception if the new value was out of range.
	 */
	public void set(int i) throws ValidationException {
		this.i = i;
	}

	/**
	 * "Construct" the property from a String argument list.
	 * The same as fromString, as there are no additional arguments other
	 * than the value.
	 * @param arguments a string which can be converted into an int
	 * @exception ValidationException if the argument cannot be converted to an int
	 */
	public void construct(String arguments) throws ValidationException {
		fromString(arguments);
	}

	/**
	 * Change the value of the property from a String representation of the new value.
	 * @param arguments a string which can be converted into an int
	 * @exception ValidationException if the argument cannot be converted to an int
	 */
	public void fromString(String s) throws ValidationException {
		try {
			set(Integer.parseInt(s));
		}
		catch(NumberFormatException nf) {
			throw new ValidationException("not an integer");
		}
	}

	/**
	 * Return a String representation of the value.
	 * @return the int converted to a String
	 */
	public String toString() {
		return String.valueOf(i);
	}

	/**
	 * Return a String representation of the arguments necessary to construct the property.
	 * @return the int converted to a String
	 */
	public String arguments() {
		return toString();
	}

	/** Empty constructor used immediately before <B>construct</B> is called */
	TIntegerProperty() {
	}
}
