package com.trumphurst.utils;

/** A TProperty which holds a String value, and cannot be changed once constructed */
public class TFixedStringProperty extends TStringProperty {
	static RCSVersion version = new RCSVersion("$Id: TFixedStringProperty.java 1.2 1997/09/19 17:09:19 nikki Exp nikki $");
	/**
	 * Construct with a value
	 * @param s the value
	 */
	public TFixedStringProperty(String s) {
		super(s);
	}

	/** 
	 * Set the value 
	 * @param s the value to set
	 * @exception ValidationException thrown if s is not equal to the 
	 * original value (except if the original value is null, of course).
	 */
	public void set(String s) throws ValidationException {
		if(this.s == null)
			this.s = s;
		else if(!s.equals(this.s))
			throw new ValidationException("value may not be changed");
	}

	/** Empty constructor used immediately before <B>construct</B> is called */
	TFixedStringProperty() {
	}
}
