package com.trumphurst.utils;

/** A TProperty which holds a double value */
public class TDoubleProperty implements TProperty {
	static RCSVersion version = new RCSVersion("$Id: TDoubleProperty.java 1.2 1997/09/19 17:09:17 nikki Exp nikki $");
	/** The value */
	protected double d;

	/**
	 * Construct with a value
	 * @param d the value
	 */
	public TDoubleProperty(double d) {
		this.d = d;
	}

	/** Return the value */
	public double get() {
		return d;
	}

	/**
	 * Return the double value of the specified property in the properties list.
	 * Verifies that the key exists, and refers to a TDoubleProperty (or a
	 * subclass).
	 * @param properties the properties list
	 * @key the key to look up
	 * @return the double value of the property, or 0
	 */
	public static double get(TProperties properties, String key) {
		TProperty p = properties.get(key);
		if(p != null && p instanceof TDoubleProperty)
			return ((TDoubleProperty)p).get();
		return 0.0;
	}

	/** 
	 * Set the value 
	 * @param d the value to set
	 * @exception ValidationException never thrown by this class, but a
	 * subclass that only permits a limited range of values might throw
	 * the exception if the new value was out of range.
	 */
	public void set(double d) throws ValidationException {
		this.d = d;
	}

	/**
	 * "Construct" the property from a String argument list.
	 * The same as fromString, as there are no additional arguments other
	 * than the value.
	 * @param arguments a string which can be converted into a double
	 * @exception ValidationException if the argument cannot be converted to a double
	 */
	public void construct(String arguments) throws ValidationException {
		fromString(arguments);
	}

	/**
	 * Change the value of the property from a String representation of the new value.
	 * @param arguments a string which can be converted into a double
	 * @exception ValidationException if the argument cannot be converted to a double
	 */
	public void fromString(String s) throws ValidationException {
		try {
			set(Double.valueOf(s).doubleValue());
		}
		catch(NumberFormatException nf) {
			throw new ValidationException("not a double");
		}
	}

	/**
	 * Return a String representation of the value.
	 * @return the double converted to a String
	 */
	public String toString() {
		return String.valueOf(d);
	}

	/**
	 * Return a String representation of the arguments necessary to construct the property.
	 * @return the double converted to a String
	 */
	public String arguments() {
		return toString();
	}

	/** Empty constructor used immediately before <B>construct</B> is called */
	TDoubleProperty() {
	}
}
