package com.trumphurst.utils;

/** A TProperty which holds a boolean value */
public class TBooleanProperty implements TProperty {
	static RCSVersion version = new RCSVersion("$Id: TBooleanProperty.java 1.2 1997/09/19 17:09:16 nikki Exp nikki $");
	/** The value */
	protected boolean b;

	/**
	 * Construct with a value
	 * @param the value
	 */
	public TBooleanProperty(boolean b) {
		this.b = b;
	}

	/** Return the value */
	public boolean get() {
		return b;
	}

	/**
	 * Return the boolean value of the specified property in the properties list.
	 * Verifies that the key exists, and refers to a TBooleanProperty (or a
	 * subclass).
	 * @param properties the properties list
	 * @key the key to look up
	 * @return the boolean value of the property, or false
	 */
	public static boolean get(TProperties properties, String key) {
		TProperty p = properties.get(key);
		if(p != null && p instanceof TBooleanProperty)
			return ((TBooleanProperty)p).get();
		return false;
	}

	/** 
	 * Set the value 
	 * @param b the value to set
	 * @exception ValidationException never thrown by this class, but a
	 * subclass that only permits a limited range of values might throw
	 * the exception if the new value was out of range.
	 */
	public void set(boolean b) throws ValidationException {
		this.b = b;
	}

	/**
	 * "Construct" the property from a String argument list.
	 * The same as fromString, as there are no additional arguments other
	 * than the value.
	 * @param arguments "true", "false", "yes", "no", "1" or "0"
	 * @exception ValidationException if the argument is none of the above
	 */
	public void construct(String arguments) throws ValidationException {
		fromString(arguments);
	}

	/**
	 * Change the value of the property from a String representation of the new value.
	 * @param arguments "true", "false", "yes", "no", "1" or "0"
	 * @exception ValidationException if the argument is none of the above
	 */
	public void fromString(String s) throws ValidationException {
		if(s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equals("1"))
			b = true;
		else if(s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equals("0"))
			b = false;
		else
			throw new ValidationException("neither true nor false");
	}

	/**
	 * Return a String representation of the value.
	 * @return "true" or "false"
	 */
	public String toString() {
		return String.valueOf(b);
	}

	/**
	 * Return a String representation of the arguments necessary to construct the property.
	 * @return "true" or "false"
	 */
	public String arguments() {
		return toString();
	}

	/** Empty constructor used immediately before <B>construct</B> is called */
	TBooleanProperty() {
	}
}
