package com.trumphurst.utils;

import java.util.*;

public class SortedVector {
	static RCSVersion version = new RCSVersion("$Id: SortedVector.java 1.2 1997/09/19 17:09:15 nikki Exp nikki $");
	Vector v = new Vector();

	public SortedVector() {
	}

	final public void clear() {
		v = new Vector();
	}

	final public Object elementAt(int i) {
		return v.elementAt(i);
	}

	final public Enumeration elements() {
		return v.elements();
	}

	final public int find(String key) {
		int bottom = 0;
		int top = v.size() - 1;
		int j = top / 2;
		int c = 0;

		if(top < 0)
			return 0;
		while((c = key.compareTo(v.elementAt(j).toString())) != 0) {
			if(c < 0) {
				if(j <= bottom)
					return bottom;
				top = j;
				j = bottom + (top - bottom) / 2;
			} else {
				if(j >= top)
					return v.size();
				bottom = j + 1;
				j = bottom + (top - bottom) / 2;
			}
		}
		return j;
	}

    final public Object get(String key) {
		int i = find(key);

		if(i == v.size())
			return null;
		Object o = v.elementAt(i);

		return key.equals(o.toString()) ? o : null;
	}

    final public boolean isEmpty() {
		return v.size() == 0;
	}

    final public Object put(Object obj) {
		String key = obj.toString();
		int i = find(key);

		if(i < v.size()) {
			Object o = v.elementAt(i);

			if(key.equals(o.toString()))
				v.setElementAt(obj, i);
			else {
				o = null;
				v.insertElementAt(obj, i);
			}
			return o;
		} else
			v.addElement(obj);
		return null;
	}

	final public Object remove(String key) {
		int i = find(key);

		if(i < v.size()) {
			Object o = v.elementAt(i);

			if(key.equals(o.toString()))
				v.removeElementAt(i);
			else
				o = null;
			return o;
		}
		return null;
	}

    final public int size() {
		return v.size();
	}

}
