package com.trumphurst.utils;

import java.util.*;

public class SortedEnumeration implements Enumeration {
	static RCSVersion version = new RCSVersion("$Id: SortedEnumeration.java 1.2 1997/09/19 17:09:14 nikki Exp nikki $");
	private Vector v;
	private int next;

	public SortedEnumeration(Enumeration e, Comparer c) {
		v = new Vector();
		next = 0;

		try {
			while(e.hasMoreElements()) {
				Object key = e.nextElement();
				int i;

				for(i = 0; i < v.size(); i++)
					if(c.compare(key, v.elementAt(i)) < 0)
						break;
				v.insertElementAt(key, i);
			}
		}
		catch(NoSuchElementException nse) {
		}
	}

	public boolean hasMoreElements() {
		return next < v.size();
	}

	public Object nextElement() throws NoSuchElementException {
		if(next >= v.size())
			throw new NoSuchElementException();
		return v.elementAt(next++);
	}
}
