package com.trumphurst.utils;

import java.util.*;

public class SortedDictionary extends Dictionary {
	static RCSVersion version = new RCSVersion("$Id: SortedDictionary.java 1.2 1997/09/19 17:09:14 nikki Exp nikki $");
	SortedVector v = new SortedVector();

	public SortedDictionary() {
	}

	final public void clear() {
		v.clear();
	}

	final public Object elementAt(int i) {
		return ((SortedDictionaryElement)v.elementAt(i)).element;
	}

	final public Enumeration elements() {
		return new SortedDictionaryElementEnumeration(this);
	}

    final public Object get(Object key) {
		Object e = v.get(key.toString());
		return (e == null) ? null : ((SortedDictionaryElement)e).element;
	}

    final public boolean isEmpty() {
		return v.isEmpty();
	}

	final public Object keyAt(int i) {
		return ((SortedDictionaryElement)v.elementAt(i)).key;
	}

	final public Enumeration keys() {
		return new SortedDictionaryKeyEnumeration(this);
	}

    final public Object put(Object key, Object value) {
		Object e = v.put(new SortedDictionaryElement(key, value));
		return (e == null) ? null : ((SortedDictionaryElement)e).element;
	}

	final public Object remove(Object key) {
		Object e = v.remove(key.toString());
		return (e == null) ? null : ((SortedDictionaryElement)e).element;
	}

    final public int size() {
		return v.size();
	}
}


class SortedDictionaryElement {
	String k;
	Object key;
	Object element;

	SortedDictionaryElement(Object key, Object element) {
		this.key = key;
		this.element = element;
		k = key.toString();
	}

	final public String toString() {
		return k;
	}
}

class SortedDictionaryEnumerator {
	SortedDictionary d;
	int index;

	SortedDictionaryEnumerator(SortedDictionary d) {
		this.d = d;
		index = 0;
	}

	public boolean hasMoreElements() {
		return (index < d.size());
	}

	SortedDictionaryElement nextItem() {
		return (SortedDictionaryElement)d.v.elementAt(index++);
	}
}

class SortedDictionaryKeyEnumeration extends SortedDictionaryEnumerator implements Enumeration {
	SortedDictionaryKeyEnumeration(SortedDictionary d) {
		super(d);
	}

	final public Object nextElement() {
		return nextItem().key;
	}
}


class SortedDictionaryElementEnumeration extends SortedDictionaryEnumerator implements Enumeration {
	SortedDictionaryElementEnumeration(SortedDictionary d) {
		super(d);
	}

	final public Object nextElement() {
		return nextItem().element;
	}
}

