package com.trumphurst.utils;

import java.io.*;

public class Debug {
	public static final boolean on = true;
	static RCSVersion version = new RCSVersion("$Id: Debug.java 1.2 1997/09/19 17:09:47 nikki Exp nikki $, debugging" + (on ? "on" : "off"));

	public static void print(Object caller, String message, Object argument) {
		if(on) {
			String c = (caller == null) ? "" : caller.toString();
			String a = (argument == null) ? "" : argument.toString();

			if(c.length() > 79)
				c = c.substring(0, 79);
			if(a.length() > 77)
				a = a.substring(0, 77);
			System.out.println(c + ":" + message + "(" + a + ")");
		}
	}

	public static void print(Object caller, String message) {
		if(on)
			print(caller, message, null);
	}

	public static void print(String message) {
		if(on)
			print(null, message, null);
	}

}

