package com.trumphurst.controls;

import com.trumphurst.utils.*;

/** This interface is a "functor" for processing Trees.
 * To traverse every item in a Tree, create a TreeProcessor which
 * performs whatever function you want to do to each item in the tree,
 * then pass the TreeProcessor to the ProcessTree method of the root.
 * @see Tree
 * @see Tree#ProcessTree
 */
public interface TreeProcessor {
	static RCSVersion version = new RCSVersion("$Id: TreeProcessor.java 1.3 1997/09/19 17:09:41 nikki Exp nikki $");
	/** Called for each item in the Tree.
	 * @param item The item to process.
	 * @return true to continue the search, false to stop the search immediately.
	 */
	boolean continueProcess(Tree item);
}

