package com.trumphurst.controls;

import com.trumphurst.utils.*;

/**
 * Document/View architecture - a View of the Document.
 * This interface is implemented by any control which provides
 * a view of a TDocument. The document maintains a list of all
 * active views, and uses this interface to inform them if something
 * in the document has changed.
 * The Document/View architecture allows the same document to be displayed
 * in multiple different Views (representations). This implementation
 * is sufficiently light to be efficient even if there is only one View of
 * each Document.
 * @see TDocument
 * @see MultiColumnList
 */
public interface TView {
	static RCSVersion version = new RCSVersion("$Id: TView.java 1.3 1997/09/19 17:09:31 nikki Exp nikki $");
	/** The Document has changed - update the whole view. */
	public void update();

	/** 
	 * Part of the Document has changed. 
	 * @param o Object representing that part of the document.
	 * which has changed.
	 */
	public void update(Object o);

	/**
	 * Attach the View to the Document.
	 * @param document the Document.
	 * @see TDocument#addView
	 */
	public void attach(TDocument d);

	/**
	 * Detach the View from the Document.
	 * @see TDocument#removeView
	 */
	public void detach(TDocument d);

}


