package com.trumphurst.controls;

import com.trumphurst.utils.*;
import java.util.*;
import java.awt.*;

/** 
 * Document/View architecture - a Document.
 * The document maintains a list of all active views, and informs them
 * if something in the document has changed.
 * The Document/View architecture allows the same document to be displayed
 * in multiple different Views (representations). This implementation
 * is sufficiently light to be efficient even if there is only one View of
 * each Document.
 * @see TView
 * @see TRowDocument
 * @see TTreeListDocument
 */
public class TDocument {
	static RCSVersion version = new RCSVersion("$Id: TDocument.java 1.4 1997/09/19 17:09:36 nikki Exp nikki $");
	/** A list of all the TViews of this document. */
	protected Vector views = new Vector();
	/** The name of the document. */
	protected String name;

	/** Constructor.
	 * @param name The name of the document.
	 */
	public TDocument(String name) {
		this.name = name;
	}

	/** Return the name of the document. */
	public String getName() {
		return name;
	}

	/** Update all views of the document.
	 * Called when the whole document (or a large part) has changed.
	 */
	public void updateAllViews() {
		for(int i = 0; i < views.size(); i++)
			((TView)views.elementAt(i)).update();
	}

	/** Update all views of the document.
	 * Called when a single item in the document has changed.
	 */
	public void updateAllViews(Object o) {
		for(int i = 0; i < views.size(); i++)
			((TView)views.elementAt(i)).update(o);
	}

	/** Add a new view to the list of views. 
	 * Note that this calls the TView's attach method if it isn't 
	 * already attached.
	 */
	public void addView(TView v) {
		if(!views.contains(v)) {
			views.addElement(v);
			v.attach(this);
		}
	}

	/** Remove a view from the list of views. 
	 * Note that this calls the TView's detach method if it was indeed
	 * in the list of views for this document.
	 */
	public void removeView(TView v) {
		if(views.removeElement(v))
			v.detach(this);
	}

	public boolean keyDown(TView v, Event e, int key) {
		return false;
	}

}
