package com.trumphurst.controls;

import com.trumphurst.utils.*;
import java.awt.*;

/** ObjectPainter to paint a column of a MultiColumnList with the 
 * toString value of the object. Many other ObjectPainters are derived
 * from this one, as it holds the column title, and it provides a
 * useful utility function to paint a String, and some useful cached
 * information about the current font.
 * @see MultiColumnList
 * @see StringArrayPainter
 * @see TreePainter
 */
public class StringPainter implements ObjectPainter {
	static RCSVersion version = new RCSVersion("$Id: StringPainter.java 1.4 1997/09/19 17:09:35 nikki Exp nikki $");
	/** Heading for the column. */
	private String title;
	/** Cached FontMetrics. Updated each time the title is painted. */
	protected FontMetrics fm;
	/** Cached offset of text base line in cell Rectangle. 
	 * Updated each time the title is painted. 
	 */
	protected int textOffset;

	/** Constructor.
	 * @param title The column heading.
	 */
	public StringPainter(String title) {
		this.title = title;
	}

	/** Change the column heading. */
	public void changeTitle(String title) {
		this.title = title;
	}
	
	/** Utility function to paint a String at a point.
	 * @param g The Graphics on which to paint.
	 * @param x The x position.
	 * @param y The y position of the <U>top</U> of the rectangle 
	 *	to contain the text.
	 * @param s The String to paint.
	 */
	protected void paintString(Graphics g, int x, int y, String s) {
		g.drawString(s, x, y + textOffset);
	}
	
	/** Paints the title as the column heading. */
	public void paintTitle(Graphics g, Rectangle r, boolean clip) {
		fm = g.getFontMetrics();

		int tw = fm.stringWidth(title);

		textOffset = fm.getHeight() - fm.getDescent();	// useful font metrics

		if (tw > r.width)
			tw = r.width;		// If too big, place at left
		paintString(g, r.x + (r.width - tw) / 2, r.y, title);
	}

	/** Paints the String returned by o.toString(). */
	public void paintObject(Graphics g, Rectangle r, Object o, boolean clip) {
		paintString(g, r.x, r.y, o.toString());
	}

}


