package com.trumphurst.controls;

import com.trumphurst.utils.*;
import java.awt.*;

/** ObjectPainter to paint a column of a MultiColumnList whose elements 
 * are String arrays.
 * @see MultiColumnList
 */
public class StringArrayPainter extends StringPainter {
	static RCSVersion version = new RCSVersion("$Id: StringArrayPainter.java 1.4 1997/09/19 17:09:34 nikki Exp nikki $");
	/** Which element in the array to paint. */
	private int item;

	/** Constructor.
	 * @param item Which element in the array corresponds to this column.
	 * @param title The column title.
	 */
	public StringArrayPainter(int item, String title) {
		super(title);
		this.item = item;
	}

	public void paintObject(Graphics g, Rectangle r, Object o, boolean clip) {
			String [] array = (String [])o;

			super.paintObject(g, r, array[item], clip);
	}

}


