package com.trumphurst.controls;

import com.trumphurst.utils.*;
import java.awt.*;

/** Interface which paints each cell of a column and the column title 
 * in a MultiColumnList.
 * An ObjectPainter has to be provided for each column when constructing a 
 * MultiColumnList.
 * Some ready-made ObjectPainters are provided.
 * @see MultiColumnList
 * @see StringPainter
 * @see TreePainter
 * @see StringArrayPainter
 */
public interface ObjectPainter {
	static RCSVersion version = new RCSVersion("$Id: ObjectPainter.java 1.4 1997/09/19 17:09:32 nikki Exp nikki $");
	/** Paint the title.
	 * @param g Graphics onto which to paint it.
	 * @param r The area to contain the title.
	 * @param clip Whether to clip to the Rectangle.
	 */
	public void paintTitle(Graphics g, Rectangle r, boolean clip);
	/** Paint the cell.
	 * @param g Graphics onto which to paint it.
	 * @param r The area of the cell.
	 * @param o Object (row) to paint.
	 * @param clip Whether to clip to the Rectangle.
	 */
	public void paintObject(Graphics g, Rectangle r, Object o, boolean clip);

}


