package com.trumphurst.controls;

import com.trumphurst.utils.*;
import java.awt.*;

/**
 * Lightweight container with a border, title, etc.
 */
public class Group extends Panel /* Container if Lighweights worked */ {
	static RCSVersion version = new RCSVersion("$Id$");
	//****************************
	// Constructors
	//****************************
	/** 
	 * Constructor.
	 * @param title The title to show, or null for none.
	 * @param border The border type to draw.
	 * Can use predefined BorderTypes shown below.
	 * @see SUNKEN
	 * @see RAISED
	 * @see FLAT
	 * @see NONE
	 */
	public Group(String title, int border) {
		myinsets = new Insets(2, 2, 2, 2);
		if(title != null) {
			setName(title);
			this.title = title;
			myinsets.top += 10;	// Argh! Fudge - should use font height.
		}
		this.border = border;
	}

	/** 
	 * Constructor (no title).
	 * @param border The border type to draw.
	 * Can use predefined BorderTypes shown below.
	 * @see SUNKEN
	 * @see RAISED
	 * @see FLAT
	 * @see NONE
	 */
	public Group(int border) {
		this(null, border);
	}

	//****************************
	// Overridden public methods
	//****************************
	
	public void paint(Graphics g) {
		Dimension d = getSize();

		super.paint(g);
		g.setColor(getForeground());
		switch(border) {
		case SUNKEN:
			g.draw3DRect(myinsets.left / 2, myinsets.top / 2, 
					d.width - (myinsets.left + myinsets.right) / 2,
					d.height - (myinsets.top + myinsets.bottom) / 2, false);
			break;
		case RAISED:
			g.draw3DRect(myinsets.left / 2, myinsets.top / 2, 
					d.width - (myinsets.left + myinsets.right) / 2,
					d.height - (myinsets.top + myinsets.bottom) / 2, true);
			break;
		case FLAT:
			g.drawRoundRect(myinsets.left / 2, myinsets.top / 2, 
					d.width - (myinsets.left + myinsets.right) / 2,
					d.height - (myinsets.top + myinsets.bottom) / 2,
					4, 4);
			break;
		}
		if(title != null) {
			FontMetrics fm = g.getFontMetrics();

			g.setColor(getBackground());
			g.fillRect(myinsets.left + 2, 1, fm.stringWidth(title), fm.getHeight());
			g.setColor(getForeground());
			g.drawString(title, myinsets.left + 2, myinsets.top - 1);
		}
	}

    /**
     * Returns the insets of the container. The insets indicate the size of
     * the border of the container. A Frame, for example, will have a top inset
     * that corresponds to the height of the Frame's title bar. 
     * @see LayoutManager
     */
    public Insets getInsets() {
    	return insets();
    }

    /**
     * @deprecated As of JDK version 1.1,
     * replaced by getInsets().
     */
    public Insets insets() {
		return myinsets;
    }

	//****************************
	// Public static variables
	//****************************
	public static final int NONE = 0;
	public static final int SUNKEN = 1;
	public static final int RAISED = 2;
	public static final int FLAT = 3;

	//****************************
	// Variables
	//****************************

	String title;
	int border;
	Insets myinsets;
}

