/*
 * Definitions for simple system simulator that uses DiskSim as a slave.
 *
 * Contributed by Eran Gabber of Lucent Technologies - Bell Laboratories
 *
 */

typedef	double SysTime;		/* system time in seconds.usec */

typedef	struct	{		/* System level request */
	char type;		/* 'R' denotes read; 'W' denotes write */
	short devno;
	unsigned long blkno;
	int bytecount;
	SysTime start;
} Request;

/* routines for translating between the system-level simulation's simulated */
/* time format (whatever it is) and disksim's simulated time format (a      */
/* double, representing the number of milliseconds from the simulation's    */
/* initialization).                                                         */

/* In this example, system time is in seconds since initialization */
#define SYSSIMTIME_TO_MS(syssimtime)    (syssimtime*1e3)
#define MS_TO_SYSSIMTIME(curtime)       (curtime/1e3)

/* routine for determining a read request */
#define	isread(r)	((r->type == 'R') || (r->type == 'r'))

/* exported by disksim_interface.c */
struct disksim;
struct disksim * disksim_interface_initialize (void *addr, int len, const char *pfile, const char *ofile);
void disksim_interface_shutdown (struct disksim *disksim_in, SysTime syssimtime);
void disksim_interface_dump_stats (struct disksim *disksim_in, SysTime syssimtime);
void disksim_interface_internal_event (void *disksim_in, SysTime t);
void disksim_interface_request_arrive (struct disksim *disksim_in, SysTime syssimtime, Request *requestdesc);

/* exported by syssim_driver.c */
void syssim_report_completion(SysTime syssimtime, Request *r);
void syssim_schedule_callback(void (*f)(void *,double), SysTime t);
void syssim_report_completion(SysTime t, Request *r);
void syssim_deschedule_callback(void (*f)());

