
/*
 * DiskSim Storage Subsystem Simulation Environment (Version 2.0)
 * Revision Authors: Greg Ganger
 * Contributors: Ross Cohen, John Griffin, Steve Schlosser
 *
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef DISKSIM_SIMPLEDISK_H
#define DISKSIM_SIMPLEDISK_H

/* externalized disksim_simpledisk.c functions */

void    simpledisk_read_toprints (FILE *parfile);
void    simpledisk_read_specs (FILE *parfile, int devno, int copies);
void    simpledisk_set_syncset (int setstart, int setend);
void    simpledisk_param_override (char *paramname, char *paramval, int first, int last);
void    simpledisk_setcallbacks (void);
void    simpledisk_initialize (void);
void    simpledisk_resetstats (void);
void    simpledisk_printstats (void);
void    simpledisk_printsetstats (int *set, int setsize, char *sourcestr);
void    simpledisk_cleanstats (void);
int     simpledisk_set_depth (int devno, int inbusno, int depth, int slotno);
int     simpledisk_get_depth (int devno);
int     simpledisk_get_inbus (int devno);
int     simpledisk_get_busno (ioreq_event *curr);
int     simpledisk_get_slotno (int devno);
int     simpledisk_get_number_of_blocks (int devno);
int     simpledisk_get_maxoutstanding (int devno);
int     simpledisk_get_numdisks (void);
int     simpledisk_get_numcyls (int devno);
double  simpledisk_get_blktranstime (ioreq_event *curr);
int     simpledisk_get_avg_sectpercyl (int devno);
void    simpledisk_get_mapping (int maptype, int devno, int blkno, int *cylptr, int *surfaceptr, int *blkptr);
void    simpledisk_event_arrive (ioreq_event *curr);
int     simpledisk_get_distance (int devno, ioreq_event *req, int exact, int direction);
double  simpledisk_get_servtime (int devno, ioreq_event *req, int checkcache, double maxtime);
double  simpledisk_get_acctime (int devno, ioreq_event *req, double maxtime);
void    simpledisk_bus_delay_complete (int devno, ioreq_event *curr, int sentbusno);
void    simpledisk_bus_ownership_grant (int devno, ioreq_event *curr, int busno, double arbdelay);

#endif   /* DISKSIM_SIMPLEDISK_H */

