
/*
 * DiskSim Storage Subsystem Simulation Environment (Version 2.0)
 * Revision Authors: Greg Ganger
 * Contributors: Ross Cohen, John Griffin, Steve Schlosser
 *
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include "disksim_global.h"
#include "disksim_malloc.h"

/* GROK -- temporary, while this is in progress */
#include <stdlib.h>

void * DISKSIM_malloc (int size)
{
   void *addr;

   if (disksim == NULL) {
      fprintf (stderr, "DISKSIM_malloc: disksim structure not yet initialized\n");
      exit(0);
   }

   addr = disksim->startaddr + disksim->curroffset;

   if ((disksim->totallength - disksim->curroffset) >= size) {
      disksim->curroffset += rounduptomult(size,8);

   } else {
      fprintf (stderr, "DISKSIM_malloc: allocated space for disksim run has run out (%d)\n", disksim->totallength);
      exit (0);
   }

   return (addr);
}

