
/*
 * DiskSim Storage Subsystem Simulation Environment (Version 2.0)
 * Revision Authors: Greg Ganger
 * Contributors: Ross Cohen, John Griffin, Steve Schlosser
 *
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef DISKSIM_DEVICE_H
#define DISKSIM_DEVICE_H

#include "disksim_iosim.h"


#define DEVICETYPE_MIN		0
#define DEVICETYPE_DISK		1
#define DEVICETYPE_SIMPLEDISK	2
#define DEVICETYPE_MEMSDEVICE   3
#define DEVICETYPE_MAX		4


typedef struct device_info {
   int numdevices;
   int devicetypes[MAXDEVICES];	/* actual type of device */
   int devicenos[MAXDEVICES];	/* number among devices of that device type */
   int maxdeviceno[DEVICETYPE_MAX];	/* maximum deviceno of each devicetype */
   int device_printqueuestats;
   int device_printcritstats;
   int device_printidlestats;
   int device_printintarrstats;
   int device_printsizestats;
   int device_printseekstats;
   int device_printlatencystats;
   int device_printxferstats;
   int device_printacctimestats;
   int device_printinterferestats;
   int device_printbufferstats;
} device_info_t;


/* remapping #defines for some variables in device_info_t */
#define device_printqueuestats      (disksim->deviceinfo->device_printqueuestats)
#define device_printcritstats       (disksim->deviceinfo->device_printcritstats)
#define device_printidlestats       (disksim->deviceinfo->device_printidlestats)
#define device_printintarrstats     (disksim->deviceinfo->device_printintarrstats)
#define device_printsizestats       (disksim->deviceinfo->device_printsizestats)
#define device_printseekstats       (disksim->deviceinfo->device_printseekstats)
#define device_printlatencystats    (disksim->deviceinfo->device_printlatencystats)
#define device_printxferstats       (disksim->deviceinfo->device_printxferstats)
#define device_printacctimestats    (disksim->deviceinfo->device_printacctimestats)
#define device_printinterferestats  (disksim->deviceinfo->device_printinterferestats)
#define device_printbufferstats     (disksim->deviceinfo->device_printbufferstats)


/* disksim_device.c functions */

void    device_read_toprints (FILE *parfile);
void    device_read_specs (FILE *parfile);
void    device_read_syncsets (FILE *parfile);
void    device_param_override (char *paramname, char *paramval, int first, int last);
void    device_setcallbacks (void);
void    device_initialize (void);
void    device_resetstats (void);
void    device_printstats (void);
void    device_printsetstats (int *set, int setsize, char *sourcestr);
void    device_cleanstats (void);
int     device_set_depth (int diskno, int inbusno, int depth, int slotno);
int     device_get_depth (int diskno);
int     device_get_inbus (int diskno);
int     device_get_busno (ioreq_event *curr);
int     device_get_slotno (int diskno);
int     device_get_number_of_blocks (int diskno);
int     device_get_maxoutstanding (int diskno);
int     device_get_numdevices (void);
int     device_get_numcyls (int diskno);
double  device_get_blktranstime (ioreq_event *curr);
int     device_get_avg_sectpercyl (int devno);
void    device_get_mapping (int maptype, int diskno, int blkno, int *cylptr, int *surfaceptr, int *blkptr);
void    device_event_arrive (ioreq_event *curr);
int     device_get_distance (int diskno, ioreq_event *req, int exact, int direction);
double  device_get_servtime (int diskno, ioreq_event *req, int checkcache, double maxtime);
double  device_get_acctime (int diskno, ioreq_event *req, double maxtime);
void    device_bus_delay_complete (int devno, ioreq_event *curr, int sentbusno);
void    device_bus_ownership_grant (int devno, ioreq_event *curr, int busno, double arbdelay);

#endif   /* DISKSIM_DEVICE_H */

