function [crack_img] = mask2cracks(foreground_mask)
%
% [crack_img] = mask2cracks(foreground_mask)
%
%
% ------------
% Andrew Stein
% 

if(size(foreground_mask,3)>1)
    disp('Converting foreground_mask to grayscale.');
    foreground_mask = rgb2gray(foreground_mask);
end

UP    = 1;
DOWN  = 2;
LEFT  = 4;
RIGHT = 8;
UPLEFT    = 16;
UPRIGHT   = 32;
DOWNLEFT  = 64;
DOWNRIGHT = 128;

[nrows, ncols ] = size(foreground_mask);
crack_img = zeros(nrows, ncols);

crack_img = RIGHT*(foreground_mask ~= foreground_mask(:,[2:end end])) + ...
    LEFT*(foreground_mask ~= foreground_mask(:,[1 1:end-1])) + ...
    DOWN*(foreground_mask ~= foreground_mask([2:end end],:)) + ...
    UP*(foreground_mask ~= foreground_mask([1 1:end-1],:)) + ...
    DOWNRIGHT*(foreground_mask ~= foreground_mask([2:end end],[2:end end])) + ...
    UPLEFT*(foreground_mask ~= foreground_mask([1 1:end-1],[1 1:end-1])) + ...
    DOWNLEFT*(foreground_mask ~= foreground_mask([2:end end],[1 1:end-1])) + ...
    UPRIGHT*(foreground_mask ~= foreground_mask([1 1:end-1],[2:end end]));

crack_img = uint8(crack_img);