function [x,y,s, to_remove] = eliminate_edge_responses(x,y,s, laplacian, cracks, r)
%
% [x,y,s, to_remove] = eliminate_edge_responses(x,y,s, laplacian, cracks, r)
%
%
% ------------
% Andrew Stein
%

if(nargin < 5) 
    r = 10;
end

UP_BIT = 1;
DOWN_BIT = 2;
LEFT_BIT = 3;
RIGHT_BIT = 4;
UPLEFT_BIT    = 5;
UPRIGHT_BIT   = 6;
DOWNLEFT_BIT  = 7;
DOWNRIGHT_BIT = 8;

[nrows, ncols, num_levels] = size(laplacian);

% Get neigbor indices within the pyramid (not doing subpixel
% interpolation)
% Assumes that any points at the 3D boundaries of this laplacian stack have
% been removed! No bounds checking is going on!
stepsize = 1;
x = round(x);
y = round(y);
level_offset = nrows*ncols;
index = y + (x-1)*nrows + (s-1)*level_offset;
crack_index = index - (s-1)*level_offset;
up = index - stepsize;           down = index + stepsize;
left = index - stepsize*nrows;   right = index + stepsize*nrows;
upleft = left - stepsize;        upright = right - stepsize;
downleft = left + stepsize;      downright = right + stepsize;

% Lookup the values of the laplacian at the interest point locations,
% enforcing Dirichlet boundary conditions according to the crack
% information
val = laplacian(index);
val_up = laplacian(up).*~bitget(cracks(crack_index), UP_BIT);
val_down = laplacian(down).*~bitget(cracks(crack_index), DOWN_BIT);
val_left = laplacian(left).*~bitget(cracks(crack_index), LEFT_BIT);
val_right = laplacian(right).*~bitget(cracks(crack_index), RIGHT_BIT);
val_upleft = laplacian(upleft).*~bitget(cracks(crack_index), UPLEFT_BIT);
val_upright = laplacian(upright).*~bitget(cracks(crack_index), UPRIGHT_BIT);
val_downleft = laplacian(downleft).*~bitget(cracks(crack_index), DOWNLEFT_BIT);
val_downright = laplacian(downright).*~bitget(cracks(crack_index), DOWNRIGHT_BIT);

dxx = val_left - 2*val + val_right;
dyy = val_up - 2*val + val_down;
dxy = (val_upleft - val_upright - val_downleft + val_downright)/4;

% Anywhere the trace-determinant ratio is too large (or where the
% determinant is not positive) should be removed.
determ = (dxx.*dyy - dxy.^2);
trace_sq = (dxx + dyy).^2;

ratio = inf*ones(size(determ));
index = find(determ > 0);
ratio(index) = trace_sq(index) ./ determ(index);

to_remove = find(ratio > ((r+1)^2)/r );

% disp(['   Removing ' num2str(length(to_remove)) ' interest points that are just edge responses.'])

x(to_remove) = [];
y(to_remove) = [];
s(to_remove) = [];




