function h = drawcracks(crack_img, color, linewidth)
%
% h = drawcracks(crack_img, color, linewidth)
%
%
% ------------
% Andrew Stein
%

if(nargin<3)
    linewidth = 1;
    if(nargin<2)
        color = 'r';
    end
end

UP_BIT = 1;
DOWN_BIT = 2;
LEFT_BIT = 3;
RIGHT_BIT = 4;

xlist = [];
ylist = [];

[y,x] = find(bitget(crack_img, UP_BIT));
xlist = [xlist; x-.5 x+.5];
ylist = [ylist; y-.5 y-.5];

% [y,x] = find(bitget(crack_img, DOWN_BIT));
% xlist = [xlist; x-.5 x+.5];
% ylist = [ylist; y+.5 y+.5];

[y,x] = find(bitget(crack_img, LEFT_BIT));
xlist = [xlist; x-.5 x-.5];
ylist = [ylist; y-.5 y+.5];

% [y,x] = find(bitget(crack_img, RIGHT_BIT));
% xlist = [xlist; x+.5 x+.5];
% ylist = [ylist; y-.5 y+.5];

h = plot(xlist', ylist', color, 'LineWidth', linewidth);

